/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.PermissionRegistry;
import org.molgenis.security.core.PermissionSet;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class PermissionRegistryTest {
    private PermissionRegistry permissionRegistry = new PermissionRegistry();

    @BeforeClass
    public void setUp() {
        this.permissionRegistry.addMapping((Permission)TestPermission.READ, new PermissionSet[]{PermissionSet.READ, PermissionSet.WRITE, PermissionSet.WRITEMETA});
        this.permissionRegistry.addMapping((Permission)TestPermission.UPDATE, new PermissionSet[]{PermissionSet.WRITE, PermissionSet.WRITEMETA});
        this.permissionRegistry.addMapping((Permission)TestPermission.DELETE, new PermissionSet[]{PermissionSet.WRITE, PermissionSet.WRITEMETA});
    }

    @Test
    public void testGetPermissions() {
        Assert.assertEquals((Set)this.permissionRegistry.getPermissions((Permission)TestPermission.UPDATE), (Set)ImmutableSet.of((Object)PermissionSet.WRITE, (Object)PermissionSet.WRITEMETA));
    }

    @Test
    public void testGetPermissionSets() {
        ImmutableMap expected = ImmutableMap.of((Object)PermissionSet.WRITEMETA, (Object)ImmutableSet.of((Object)((Object)TestPermission.READ), (Object)((Object)TestPermission.UPDATE), (Object)((Object)TestPermission.DELETE)), (Object)PermissionSet.WRITE, (Object)ImmutableSet.of((Object)((Object)TestPermission.READ), (Object)((Object)TestPermission.UPDATE), (Object)((Object)TestPermission.DELETE)), (Object)PermissionSet.READ, (Object)ImmutableSet.of((Object)((Object)TestPermission.READ)));
        Assert.assertEquals((Map)this.permissionRegistry.getPermissionSets(), (Map)expected);
    }

    private static enum TestPermission implements Permission
    {
        READ,
        UPDATE,
        DELETE;


        public String getDefaultDescription() {
            return this.toString();
        }
    }
}

