/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core.runas;

import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.molgenis.security.core.runas.SystemSecurityToken;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.test.context.support.WithMockUser;
import org.springframework.security.test.context.support.WithSecurityContextTestExecutionListener;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.testng.AbstractTestNGSpringContextTests;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@TestExecutionListeners(listeners={WithSecurityContextTestExecutionListener.class})
@ContextConfiguration(classes={Config.class})
public class RunAsSystemAspectTest
extends AbstractTestNGSpringContextTests {
    private SecurityContext previousContext;

    @BeforeClass
    public void setUpBeforeClass() {
        this.previousContext = SecurityContextHolder.getContext();
        SecurityContext testContext = SecurityContextHolder.createEmptyContext();
        SecurityContextHolder.setContext((SecurityContext)testContext);
    }

    @AfterClass
    public void tearDownAfterClass() {
        SecurityContextHolder.setContext((SecurityContext)this.previousContext);
    }

    @Test
    @WithMockUser
    public void testRunAsSystemRunnableAsSystem() {
        Assert.assertTrue((boolean)(this.getAuthentication() instanceof UsernamePasswordAuthenticationToken));
        Assert.assertTrue((boolean)(RunAsSystemAspect.runAsSystem(this::getAuthentication) instanceof SystemSecurityToken));
        Assert.assertTrue((boolean)(this.getAuthentication() instanceof UsernamePasswordAuthenticationToken));
    }

    private Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    @Configuration
    public static class Config {
    }
}

