/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core;

import org.mockito.Mockito;
import org.molgenis.security.core.MolgenisPasswordEncoder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class MolgenisPasswordEncoderTest {
    @Test(expectedExceptions={IllegalArgumentException.class})
    public void MolgenisPasswordEncoder() {
        new MolgenisPasswordEncoder(null);
    }

    @Test
    public void encode() {
        String password = "password";
        String encodedPassword = "encoded-password";
        BCryptPasswordEncoder bCryptPasswordEncoder = (BCryptPasswordEncoder)Mockito.mock(BCryptPasswordEncoder.class);
        Mockito.when((Object)bCryptPasswordEncoder.encode((CharSequence)password)).thenReturn((Object)encodedPassword);
        Assert.assertEquals((String)new MolgenisPasswordEncoder(bCryptPasswordEncoder).encode((CharSequence)password), (String)encodedPassword);
    }

    @Test
    public void matches() {
        String password = "password";
        String encodedPassword = "encoded-password";
        BCryptPasswordEncoder bCryptPasswordEncoder = (BCryptPasswordEncoder)Mockito.mock(BCryptPasswordEncoder.class);
        Mockito.when((Object)bCryptPasswordEncoder.matches((CharSequence)password, encodedPassword)).thenReturn((Object)true);
        Assert.assertTrue((boolean)new MolgenisPasswordEncoder(bCryptPasswordEncoder).matches((CharSequence)password, encodedPassword));
    }

    @Test
    public void matches_noMatch() {
        String password = "password";
        String encodedPassword = "encoded-password";
        BCryptPasswordEncoder bCryptPasswordEncoder = (BCryptPasswordEncoder)Mockito.mock(BCryptPasswordEncoder.class);
        Mockito.when((Object)bCryptPasswordEncoder.matches((CharSequence)password, encodedPassword)).thenReturn((Object)true);
        Assert.assertFalse((boolean)new MolgenisPasswordEncoder(bCryptPasswordEncoder).matches((CharSequence)"invalid-password", encodedPassword));
    }
}

