/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core.utils;

import java.util.Arrays;
import java.util.Collections;
import org.mockito.Mockito;
import org.molgenis.security.core.runas.SystemSecurityToken;
import org.molgenis.security.core.utils.SecurityUtils;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SecurityUtilsTest {
    private Authentication authentication;
    private UserDetails userDetails;
    private SecurityContext previousContext;

    @BeforeClass
    public void setUpBeforeClass() {
        this.previousContext = SecurityContextHolder.getContext();
        SecurityContext testContext = SecurityContextHolder.createEmptyContext();
        this.authentication = (Authentication)Mockito.mock(Authentication.class);
        testContext.setAuthentication(this.authentication);
        SecurityContextHolder.setContext((SecurityContext)testContext);
    }

    @BeforeMethod
    public void setUpBeforeMethod() {
        Mockito.reset((Object[])new Authentication[]{this.authentication});
        GrantedAuthority authority1 = (GrantedAuthority)Mockito.when((Object)((GrantedAuthority)Mockito.mock(GrantedAuthority.class)).getAuthority()).thenReturn((Object)"authority1").getMock();
        GrantedAuthority authority2 = (GrantedAuthority)Mockito.when((Object)((GrantedAuthority)Mockito.mock(GrantedAuthority.class)).getAuthority()).thenReturn((Object)"authority2").getMock();
        this.userDetails = (UserDetails)Mockito.mock(UserDetails.class);
        Mockito.when((Object)this.userDetails.getUsername()).thenReturn((Object)"username");
        Mockito.when((Object)this.userDetails.getPassword()).thenReturn((Object)"encoded-password");
        Mockito.when((Object)this.userDetails.getAuthorities()).thenReturn(Arrays.asList(authority1, authority2));
        Mockito.when((Object)this.authentication.getPrincipal()).thenReturn((Object)this.userDetails);
        Mockito.when((Object)this.authentication.getAuthorities()).thenReturn(Arrays.asList(authority1, authority2));
    }

    @AfterClass
    public void tearDownAfterClass() {
        SecurityContextHolder.setContext((SecurityContext)this.previousContext);
    }

    @Test
    public void currentUserIsAuthenticated_true() {
        Mockito.when((Object)this.authentication.isAuthenticated()).thenReturn((Object)true);
        GrantedAuthority authorityUser = (GrantedAuthority)Mockito.when((Object)((GrantedAuthority)Mockito.mock(GrantedAuthority.class)).getAuthority()).thenReturn((Object)"ROLE_USER").getMock();
        Mockito.when((Object)this.authentication.getAuthorities()).thenReturn(Collections.singletonList(authorityUser));
        Assert.assertTrue((boolean)SecurityUtils.currentUserIsAuthenticated());
    }

    @Test
    public void currentUserIsAuthenticated_false() {
        Mockito.when((Object)this.authentication.isAuthenticated()).thenReturn((Object)false);
        Assert.assertFalse((boolean)SecurityUtils.currentUserIsAuthenticated());
    }

    @Test
    public void currentUserIsAuthenticated_falseAnonymous() {
        Authentication anonymousAuthentication = (Authentication)Mockito.mock(AnonymousAuthenticationToken.class);
        Mockito.when((Object)anonymousAuthentication.isAuthenticated()).thenReturn((Object)true);
        GrantedAuthority authoritySu = (GrantedAuthority)Mockito.when((Object)((GrantedAuthority)Mockito.mock(GrantedAuthority.class)).getAuthority()).thenReturn((Object)"ROLE_ANONYMOUS").getMock();
        Mockito.when((Object)anonymousAuthentication.getAuthorities()).thenReturn(Collections.singletonList(authoritySu));
        Assert.assertFalse((boolean)SecurityUtils.currentUserIsAuthenticated());
    }

    @Test
    public void currentUserIsSu_false() {
        Assert.assertFalse((boolean)SecurityUtils.currentUserIsSu());
        Assert.assertFalse((boolean)SecurityUtils.currentUserIsSuOrSystem());
    }

    @Test
    public void currentUserIsSu_true() {
        GrantedAuthority authoritySu = (GrantedAuthority)Mockito.when((Object)((GrantedAuthority)Mockito.mock(GrantedAuthority.class)).getAuthority()).thenReturn((Object)"ROLE_SU").getMock();
        Mockito.when((Object)this.authentication.getAuthorities()).thenReturn(Collections.singletonList(authoritySu));
        Assert.assertTrue((boolean)SecurityUtils.currentUserIsSu());
        Assert.assertTrue((boolean)SecurityUtils.currentUserIsSuOrSystem());
    }

    @Test
    public void currentUserIsSystemTrue() {
        GrantedAuthority authoritySystem = (GrantedAuthority)Mockito.when((Object)((GrantedAuthority)Mockito.mock(GrantedAuthority.class)).getAuthority()).thenReturn((Object)"ROLE_SYSTEM").getMock();
        Mockito.when((Object)this.authentication.getAuthorities()).thenReturn(Collections.singletonList(authoritySystem));
        Assert.assertTrue((boolean)SecurityUtils.currentUserIsSystem());
        Assert.assertTrue((boolean)SecurityUtils.currentUserIsSuOrSystem());
    }

    @Test
    public void currentUserIsSystemFalse() {
        Mockito.when((Object)this.userDetails.getUsername()).thenReturn((Object)"user");
        Assert.assertFalse((boolean)SecurityUtils.currentUserIsSystem());
        Assert.assertFalse((boolean)SecurityUtils.currentUserIsSuOrSystem());
    }

    @Test
    public void getCurrentUsernameUserDetails() {
        Assert.assertEquals((String)SecurityUtils.getCurrentUsername(), (String)this.userDetails.getUsername());
    }

    @Test
    public void getCurrentUsernameSystemPrincipal() {
        try {
            SecurityContextHolder.getContext().setAuthentication((Authentication)SystemSecurityToken.getInstance());
            Assert.assertNull((Object)SecurityUtils.getCurrentUsername());
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(this.authentication);
        }
    }

    @Test
    public void isUserInRole() {
        Assert.assertTrue((boolean)SecurityUtils.currentUserHasRole((String[])new String[]{"authority1"}));
        Assert.assertTrue((boolean)SecurityUtils.currentUserHasRole((String[])new String[]{"authority2"}));
        Assert.assertTrue((boolean)SecurityUtils.currentUserHasRole((String[])new String[]{"authority1", "authority2"}));
        Assert.assertTrue((boolean)SecurityUtils.currentUserHasRole((String[])new String[]{"authority2", "authority1"}));
        Assert.assertTrue((boolean)SecurityUtils.currentUserHasRole((String[])new String[]{"authority1", "authority3"}));
    }
}

