/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.security.core.model.GroupValue;
import org.molgenis.security.core.model.PackageValue;
import org.molgenis.security.core.model.RoleValue;
import org.springframework.stereotype.Component;

@Component
public class GroupValueFactory {
    public GroupValue createGroup(String groupName, String label, @Nullable @CheckForNull String description, boolean publiclyVisible, Collection<String> roleLabels) {
        GroupValue.Builder groupBuilder = GroupValue.builder().setName(groupName).setLabel(label).setPublic(publiclyVisible);
        Optional.ofNullable(description).ifPresent(groupBuilder::setDescription);
        PackageValue.Builder packageBuilder = PackageValue.builder().setName(groupName.replace('-', '_')).setLabel(label);
        Optional.ofNullable(description).ifPresent(packageBuilder::setDescription);
        PackageValue rootPackage = packageBuilder.build();
        groupBuilder.setRootPackage(rootPackage);
        ImmutableList.Builder<RoleValue> rolesBuilder = groupBuilder.rolesBuilder();
        roleLabels.stream().map(roleLabel -> GroupValueFactory.createRoleValue(groupName, label, roleLabel)).forEach(arg_0 -> rolesBuilder.add(arg_0));
        return groupBuilder.build();
    }

    public GroupValue createGroup(String groupName, String label, Collection<String> roleLabels) {
        return this.createGroup(groupName, label, null, true, roleLabels);
    }

    public static String createRoleName(String groupName, String roleLabel) {
        return (groupName + " " + roleLabel).replaceAll("[- ]+", "_").toUpperCase();
    }

    private static RoleValue createRoleValue(String groupName, String groupLabel, String roleLabel) {
        return RoleValue.builder().setName(GroupValueFactory.createRoleName(groupName, roleLabel)).setLabel(roleLabel).setDescription(groupLabel + " " + roleLabel).build();
    }
}

