/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core.model;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.security.core.model.RoleValue;

final class AutoValue_RoleValue
extends RoleValue {
    private final String name;
    private final String label;
    private final String description;

    private AutoValue_RoleValue(String name, String label, @Nullable String description) {
        this.name = name;
        this.label = label;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    @Nullable
    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "RoleValue{name=" + this.name + ", label=" + this.label + ", description=" + this.description + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RoleValue) {
            RoleValue that = (RoleValue)o;
            return this.name.equals(that.getName()) && this.label.equals(that.getLabel()) && (this.description == null ? that.getDescription() == null : this.description.equals(that.getDescription()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.label.hashCode();
        h *= 1000003;
        return h ^= this.description == null ? 0 : this.description.hashCode();
    }

    static final class Builder
    extends RoleValue.Builder {
        private String name;
        private String label;
        private String description;

        Builder() {
        }

        @Override
        public RoleValue.Builder setName(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public RoleValue.Builder setLabel(String label) {
            if (label == null) {
                throw new NullPointerException("Null label");
            }
            this.label = label;
            return this;
        }

        @Override
        public RoleValue.Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Override
        public RoleValue build() {
            String missing = "";
            if (this.name == null) {
                missing = missing + " name";
            }
            if (this.label == null) {
                missing = missing + " label";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_RoleValue(this.name, this.label, this.description);
        }
    }
}

