/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;
import org.molgenis.security.core.GroupValueFactory;
import org.molgenis.security.core.model.GroupValue;
import org.molgenis.security.core.model.PackageValue;
import org.molgenis.security.core.model.RoleValue;

public class GroupValueFactoryTest {
    private GroupValueFactory groupValueFactory = new GroupValueFactory();

    @Test
    void testCreateGroup() {
        GroupValue bbmri_eric = this.groupValueFactory.createGroup("bbmri-eric", "BBMRI Eric", "The world's largest biobank catalogue", true, (Collection)ImmutableList.of((Object)"Manager", (Object)"Editor", (Object)"Viewer"));
        GroupValue groupValue = GroupValueFactoryTest.getTestGroupValue();
        Assertions.assertEquals((Object)groupValue, (Object)bbmri_eric);
    }

    public static GroupValue getTestGroupValue() {
        RoleValue manager = RoleValue.builder().setName("BBMRI_ERIC_MANAGER").setLabel("Manager").setDescription("BBMRI Eric Manager").build();
        RoleValue editor = RoleValue.builder().setName("BBMRI_ERIC_EDITOR").setLabel("Editor").setDescription("BBMRI Eric Editor").build();
        RoleValue viewer = RoleValue.builder().setName("BBMRI_ERIC_VIEWER").setLabel("Viewer").setDescription("BBMRI Eric Viewer").build();
        PackageValue rootPackage = PackageValue.builder().setName("bbmri_eric").setLabel("BBMRI Eric").setDescription("The world's largest biobank catalogue").build();
        GroupValue.Builder expectedBuilder = GroupValue.builder().setName("bbmri-eric").setLabel("BBMRI Eric").setDescription("The world's largest biobank catalogue").setPublic(true).setRootPackage(rootPackage);
        expectedBuilder.rolesBuilder().add((Object)manager).add((Object)editor).add((Object)viewer);
        return expectedBuilder.build();
    }

    @ParameterizedTest
    @MethodSource(value={"roleNameProvider"})
    void testCreateRoleName(String groupName, String roleLabel, String roleName) {
        Assertions.assertEquals((Object)roleName, (Object)GroupValueFactory.createRoleName((String)groupName, (String)roleLabel));
    }

    static Object[][] roleNameProvider() {
        return new Object[][]{{"bbmri-eric", "Manager", "BBMRI_ERIC_MANAGER"}, {"bbmri-eric", "Manager", "BBMRI_ERIC_MANAGER"}, {"patientenfederatie-nederland", "Member", "PATIENTENFEDERATIE_NEDERLAND_MEMBER"}};
    }
}

