/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.PermissionRegistry;
import org.molgenis.security.core.PermissionSet;

class PermissionRegistryTest {
    private static PermissionRegistry permissionRegistry = new PermissionRegistry();

    PermissionRegistryTest() {
    }

    @BeforeAll
    static void setUp() {
        permissionRegistry.addMapping((Permission)TestPermission.READ, new PermissionSet[]{PermissionSet.READ, PermissionSet.WRITE, PermissionSet.WRITEMETA});
        permissionRegistry.addMapping((Permission)TestPermission.UPDATE, new PermissionSet[]{PermissionSet.WRITE, PermissionSet.WRITEMETA});
        permissionRegistry.addMapping((Permission)TestPermission.DELETE, new PermissionSet[]{PermissionSet.WRITE, PermissionSet.WRITEMETA});
    }

    @Test
    void testGetPermissions() {
        Assertions.assertEquals((Object)ImmutableSet.of((Object)PermissionSet.WRITE, (Object)PermissionSet.WRITEMETA), (Object)permissionRegistry.getPermissions((Permission)TestPermission.UPDATE));
    }

    @Test
    void testGetPermissionSets() {
        ImmutableMap expected = ImmutableMap.of((Object)PermissionSet.WRITEMETA, (Object)ImmutableSet.of((Object)((Object)TestPermission.READ), (Object)((Object)TestPermission.UPDATE), (Object)((Object)TestPermission.DELETE)), (Object)PermissionSet.WRITE, (Object)ImmutableSet.of((Object)((Object)TestPermission.READ), (Object)((Object)TestPermission.UPDATE), (Object)((Object)TestPermission.DELETE)), (Object)PermissionSet.READ, (Object)ImmutableSet.of((Object)((Object)TestPermission.READ)));
        Assertions.assertEquals((Object)expected, (Object)permissionRegistry.getPermissionSets());
    }

    private static enum TestPermission implements Permission
    {
        READ,
        UPDATE,
        DELETE;


        public String getDefaultDescription() {
            return this.toString();
        }
    }
}

