/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core;

import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.molgenis.security.core.SidUtils;
import org.molgenis.security.core.runas.SystemSecurityToken;
import org.springframework.security.acls.domain.GrantedAuthoritySid;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;

class SidUtilsTest {
    private SecurityContext previousContext;

    SidUtilsTest() {
    }

    @BeforeEach
    void setUpBeforeMethod() {
        this.previousContext = SecurityContextHolder.getContext();
        SecurityContext testContext = SecurityContextHolder.createEmptyContext();
        SecurityContextHolder.setContext((SecurityContext)testContext);
    }

    @AfterEach
    void tearDownAfterMethod() {
        SecurityContextHolder.setContext((SecurityContext)this.previousContext);
    }

    @Test
    void createSecurityContextSidUser() {
        String principal = "username";
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken((Object)principal, null));
        Assertions.assertEquals((Object)new PrincipalSid(principal), (Object)SidUtils.createSecurityContextSid());
    }

    @Test
    void createSecurityContextSidSystem() {
        SecurityContextHolder.getContext().setAuthentication((Authentication)SystemSecurityToken.getInstance());
        Assertions.assertEquals((Object)new GrantedAuthoritySid("ROLE_SYSTEM"), (Object)SidUtils.createSecurityContextSid());
    }

    @Test
    void createSecurityContextSidAnonymous() {
        SecurityContextHolder.getContext().setAuthentication(null);
        Assertions.assertEquals((Object)new GrantedAuthoritySid("ROLE_ANONYMOUS"), (Object)SidUtils.createSecurityContextSid());
    }

    @Test
    void createSecurityContextNoPrincipal() {
        SecurityContextHolder.getContext().setAuthentication((Authentication)new UsernamePasswordAuthenticationToken(null, null));
        Assertions.assertThrows(NullPointerException.class, SidUtils::createSecurityContextSid);
    }

    @Test
    void testCreateSidUser() {
        Sid sid = SidUtils.createUserSid((String)"username");
        Assertions.assertEquals((Object)new PrincipalSid("username"), (Object)sid);
    }

    @Test
    void testCreateSidUsernameAnonymous() {
        Sid sid = SidUtils.createUserSid((String)"anonymous");
        Assertions.assertEquals((Object)new GrantedAuthoritySid("ROLE_ANONYMOUS"), (Object)sid);
    }

    @Test
    void testCreateSidRole() {
        Sid sid = SidUtils.createRoleSid((String)"NAME");
        Assertions.assertEquals((Object)new GrantedAuthoritySid((GrantedAuthority)new SimpleGrantedAuthority("ROLE_NAME")), (Object)sid);
    }

    @Test
    void testCreateRoleAuthority() {
        Assertions.assertEquals((Object)"ROLE_NAME", (Object)SidUtils.createRoleAuthority((String)"NAME"));
    }
}

