/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core.model;

import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.molgenis.security.core.model.PackageValue;

final class AutoValue_PackageValue
extends PackageValue {
    private final String name;
    private final String label;
    private final String description;

    private AutoValue_PackageValue(String name, String label, @Nullable String description) {
        this.name = name;
        this.label = label;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    @Nullable
    @CheckForNull
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return "PackageValue{name=" + this.name + ", label=" + this.label + ", description=" + this.description + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PackageValue) {
            PackageValue that = (PackageValue)o;
            return this.name.equals(that.getName()) && this.label.equals(that.getLabel()) && (this.description == null ? that.getDescription() == null : this.description.equals(that.getDescription()));
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.name.hashCode();
        h *= 1000003;
        h ^= this.label.hashCode();
        h *= 1000003;
        return h ^= this.description == null ? 0 : this.description.hashCode();
    }

    static final class Builder
    extends PackageValue.Builder {
        private String name;
        private String label;
        private String description;

        Builder() {
        }

        @Override
        public PackageValue.Builder setName(String name) {
            if (name == null) {
                throw new NullPointerException("Null name");
            }
            this.name = name;
            return this;
        }

        @Override
        public PackageValue.Builder setLabel(String label) {
            if (label == null) {
                throw new NullPointerException("Null label");
            }
            this.label = label;
            return this;
        }

        @Override
        public PackageValue.Builder setDescription(@Nullable String description) {
            this.description = description;
            return this;
        }

        @Override
        public PackageValue build() {
            Object missing = "";
            if (this.name == null) {
                missing = (String)missing + " name";
            }
            if (this.label == null) {
                missing = (String)missing + " label";
            }
            if (!((String)missing).isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + (String)missing);
            }
            return new AutoValue_PackageValue(this.name, this.label, this.description);
        }
    }
}

