/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.molgenis.security.core.MolgenisPasswordEncoder;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;

class MolgenisPasswordEncoderTest {
    MolgenisPasswordEncoderTest() {
    }

    @Test
    void MolgenisPasswordEncoder() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new MolgenisPasswordEncoder(null));
    }

    @Test
    void encode() {
        String password = "password";
        String encodedPassword = "encoded-password";
        BCryptPasswordEncoder bCryptPasswordEncoder = (BCryptPasswordEncoder)Mockito.mock(BCryptPasswordEncoder.class);
        Mockito.when((Object)bCryptPasswordEncoder.encode((CharSequence)password)).thenReturn((Object)encodedPassword);
        Assertions.assertEquals((Object)encodedPassword, (Object)new MolgenisPasswordEncoder(bCryptPasswordEncoder).encode((CharSequence)password));
    }

    @Test
    void matches() {
        String password = "password";
        String encodedPassword = "encoded-password";
        BCryptPasswordEncoder bCryptPasswordEncoder = (BCryptPasswordEncoder)Mockito.mock(BCryptPasswordEncoder.class);
        Mockito.when((Object)bCryptPasswordEncoder.matches((CharSequence)password, encodedPassword)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)new MolgenisPasswordEncoder(bCryptPasswordEncoder).matches((CharSequence)password, encodedPassword));
    }

    @Test
    void matches_noMatch() {
        String password = "password";
        String encodedPassword = "encoded-password";
        BCryptPasswordEncoder bCryptPasswordEncoder = (BCryptPasswordEncoder)Mockito.mock(BCryptPasswordEncoder.class);
        Mockito.when((Object)bCryptPasswordEncoder.matches((CharSequence)password, encodedPassword)).thenReturn((Object)true);
        Assertions.assertFalse((boolean)new MolgenisPasswordEncoder(bCryptPasswordEncoder).matches((CharSequence)"invalid-password", encodedPassword));
    }
}

