/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core.runas;

import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;
import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.molgenis.security.core.runas.SystemSecurityToken;
import org.molgenis.test.AbstractMockitoSpringContextTests;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.test.context.support.WithMockUser;
import org.springframework.test.context.ContextConfiguration;

@ContextConfiguration(classes={Config.class})
class RunAsSystemAspectTest
extends AbstractMockitoSpringContextTests {
    private static SecurityContext previousContext;

    RunAsSystemAspectTest() {
    }

    @BeforeAll
    static void setUpBeforeClass() {
        previousContext = SecurityContextHolder.getContext();
        SecurityContext testContext = SecurityContextHolder.createEmptyContext();
        SecurityContextHolder.setContext((SecurityContext)testContext);
    }

    @AfterAll
    static void tearDownAfterClass() {
        SecurityContextHolder.setContext((SecurityContext)previousContext);
    }

    @Test
    @WithMockUser
    void testRunAsSystemRunnableAsSystem() {
        Assertions.assertTrue((boolean)(this.getAuthentication() instanceof UsernamePasswordAuthenticationToken));
        Assertions.assertTrue((boolean)(RunAsSystemAspect.runAsSystem(this::getAuthentication) instanceof SystemSecurityToken));
        Assertions.assertTrue((boolean)(this.getAuthentication() instanceof UsernamePasswordAuthenticationToken));
    }

    private Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }

    @Configuration
    static class Config {
        Config() {
        }
    }
}

