/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.core.utils;

import java.util.Arrays;
import java.util.Collections;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.molgenis.security.core.runas.SystemSecurityToken;
import org.molgenis.security.core.utils.SecurityUtils;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

class SecurityUtilsTest {
    private static Authentication authentication;
    private UserDetails userDetails;
    private static SecurityContext previousContext;

    SecurityUtilsTest() {
    }

    @BeforeAll
    static void setUpBeforeClass() {
        previousContext = SecurityContextHolder.getContext();
        SecurityContext testContext = SecurityContextHolder.createEmptyContext();
        authentication = (Authentication)Mockito.mock(Authentication.class);
        testContext.setAuthentication(authentication);
        SecurityContextHolder.setContext((SecurityContext)testContext);
    }

    @BeforeEach
    void setUpBeforeMethod() {
        Mockito.reset((Object[])new Authentication[]{authentication});
        GrantedAuthority authority1 = (GrantedAuthority)Mockito.mock(GrantedAuthority.class);
        Mockito.when((Object)authority1.getAuthority()).thenReturn((Object)"authority1");
        GrantedAuthority authority2 = (GrantedAuthority)Mockito.mock(GrantedAuthority.class);
        Mockito.when((Object)authority2.getAuthority()).thenReturn((Object)"authority2");
        this.userDetails = (UserDetails)Mockito.mock(UserDetails.class);
        Mockito.when((Object)this.userDetails.getUsername()).thenReturn((Object)"username");
        Mockito.when((Object)this.userDetails.getPassword()).thenReturn((Object)"encoded-password");
        Mockito.when((Object)this.userDetails.getAuthorities()).thenReturn(Arrays.asList(authority1, authority2));
        Mockito.when((Object)authentication.getPrincipal()).thenReturn((Object)this.userDetails);
        Mockito.when((Object)authentication.getAuthorities()).thenReturn(Arrays.asList(authority1, authority2));
    }

    @AfterAll
    static void tearDownAfterClass() {
        SecurityContextHolder.setContext((SecurityContext)previousContext);
    }

    @Test
    void currentUserIsAuthenticated_true() {
        Mockito.when((Object)authentication.isAuthenticated()).thenReturn((Object)true);
        GrantedAuthority authorityUser = (GrantedAuthority)Mockito.mock(GrantedAuthority.class);
        Mockito.when((Object)authorityUser.getAuthority()).thenReturn((Object)"ROLE_USER");
        Mockito.when((Object)authentication.getAuthorities()).thenReturn(Collections.singletonList(authorityUser));
        Assertions.assertTrue((boolean)SecurityUtils.currentUserIsAuthenticated());
    }

    @Test
    void currentUserIsAuthenticated_false() {
        Mockito.when((Object)authentication.isAuthenticated()).thenReturn((Object)false);
        Assertions.assertFalse((boolean)SecurityUtils.currentUserIsAuthenticated());
    }

    @Test
    void currentUserIsAuthenticated_falseAnonymous() {
        Authentication anonymousAuthentication = (Authentication)Mockito.mock(AnonymousAuthenticationToken.class);
        Mockito.when((Object)anonymousAuthentication.isAuthenticated()).thenReturn((Object)true);
        GrantedAuthority authoritySu = (GrantedAuthority)Mockito.mock(GrantedAuthority.class);
        Mockito.when((Object)authoritySu.getAuthority()).thenReturn((Object)"ROLE_ANONYMOUS");
        Mockito.when((Object)anonymousAuthentication.getAuthorities()).thenReturn(Collections.singletonList(authoritySu));
        Assertions.assertFalse((boolean)SecurityUtils.currentUserIsAuthenticated());
    }

    @Test
    void currentUserIsSu_false() {
        Assertions.assertFalse((boolean)SecurityUtils.currentUserIsSu());
        Assertions.assertFalse((boolean)SecurityUtils.currentUserIsSuOrSystem());
    }

    @Test
    void currentUserIsSu_true() {
        GrantedAuthority authoritySu = (GrantedAuthority)Mockito.mock(GrantedAuthority.class);
        Mockito.when((Object)authoritySu.getAuthority()).thenReturn((Object)"ROLE_SU");
        Mockito.when((Object)authentication.getAuthorities()).thenReturn(Collections.singletonList(authoritySu));
        Assertions.assertTrue((boolean)SecurityUtils.currentUserIsSu());
        Assertions.assertTrue((boolean)SecurityUtils.currentUserIsSuOrSystem());
    }

    @Test
    void currentUserIsSystemTrue() {
        GrantedAuthority authoritySystem = (GrantedAuthority)Mockito.mock(GrantedAuthority.class);
        Mockito.when((Object)authoritySystem.getAuthority()).thenReturn((Object)"ROLE_SYSTEM");
        Mockito.when((Object)authentication.getAuthorities()).thenReturn(Collections.singletonList(authoritySystem));
        Assertions.assertTrue((boolean)SecurityUtils.currentUserIsSystem());
        Assertions.assertTrue((boolean)SecurityUtils.currentUserIsSuOrSystem());
    }

    @Test
    void currentUserIsSystemFalse() {
        Mockito.when((Object)this.userDetails.getUsername()).thenReturn((Object)"user");
        Assertions.assertFalse((boolean)SecurityUtils.currentUserIsSystem());
        Assertions.assertFalse((boolean)SecurityUtils.currentUserIsSuOrSystem());
    }

    @Test
    void getCurrentUsernameUserDetails() {
        Assertions.assertEquals((Object)this.userDetails.getUsername(), (Object)SecurityUtils.getCurrentUsername());
    }

    @Test
    void getCurrentUsernameSystemPrincipal() {
        try {
            SecurityContextHolder.getContext().setAuthentication((Authentication)SystemSecurityToken.getInstance());
            Assertions.assertNull((Object)SecurityUtils.getCurrentUsername());
        }
        finally {
            SecurityContextHolder.getContext().setAuthentication(authentication);
        }
    }

    @Test
    void isUserInRole() {
        Assertions.assertTrue((boolean)SecurityUtils.currentUserHasRole((String[])new String[]{"authority1"}));
        Assertions.assertTrue((boolean)SecurityUtils.currentUserHasRole((String[])new String[]{"authority2"}));
        Assertions.assertTrue((boolean)SecurityUtils.currentUserHasRole((String[])new String[]{"authority1", "authority2"}));
        Assertions.assertTrue((boolean)SecurityUtils.currentUserHasRole((String[])new String[]{"authority2", "authority1"}));
        Assertions.assertTrue((boolean)SecurityUtils.currentUserHasRole((String[])new String[]{"authority1", "authority3"}));
    }
}

