
/* File:        org.molgenis.omx/model/GroupAuthority.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.auth.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.auth.MolgenisGroup;
import org.molgenis.omx.auth.GroupAuthority;


/**
 * Reads GroupAuthority from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class GroupAuthorityEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(GroupAuthorityEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
			
	/**
	 * Imports GroupAuthority from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<GroupAuthority> groupAuthoritysMissingRefs = new ArrayList<GroupAuthority>();
	
		//cache for objects to be imported from file (in batch)
		final List<GroupAuthority> groupAuthorityList = new ArrayList<GroupAuthority>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			GroupAuthority object = new GroupAuthority();
			object.set(entity, false);				
			groupAuthorityList.add(object);		
			
			//add to db when batch size is reached
			if(groupAuthorityList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				groupAuthoritysMissingRefs.addAll(resolveForeignKeys(db, groupAuthorityList));
				groupAuthorityList.removeAll(groupAuthoritysMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
				db.update(groupAuthorityList,dbAction, "id");
				
				//clear for next batch						
				groupAuthorityList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!groupAuthorityList.isEmpty())
		{
			total.set(total.get() + groupAuthorityList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			groupAuthoritysMissingRefs.addAll(resolveForeignKeys(db, groupAuthorityList));
			groupAuthorityList.removeAll(groupAuthoritysMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
			db.update(groupAuthorityList,dbAction, "id");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<GroupAuthority> groupAuthoritys = new ArrayList<GroupAuthority>(groupAuthoritysMissingRefs);

		int iterationCount = 0;

		do
		{
			groupAuthoritysMissingRefs = resolveForeignKeys(db, groupAuthoritysMissingRefs);
			
			LinkedHashSet<GroupAuthority> differenceSet = new LinkedHashSet<GroupAuthority>();
			Sets.symmetricDifference(new LinkedHashSet<GroupAuthority>(groupAuthoritys), new LinkedHashSet<GroupAuthority>(groupAuthoritysMissingRefs)).copyInto(differenceSet);
			List<GroupAuthority> resolvablegroupAuthoritys = new ArrayList<GroupAuthority>(differenceSet);
			
			groupAuthoritys.removeAll(resolvablegroupAuthoritys);
			
			db.update(resolvablegroupAuthoritys,dbAction, "id");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(GroupAuthority blaat : groupAuthoritysMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'groupAuthority' entity failed:"
								+ "This is probably caused by a(n) 'groupAuthority' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (groupAuthoritysMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " groupAuthority from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param groupAuthorityList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<GroupAuthority> resolveForeignKeys(Database db, List<GroupAuthority> groupAuthorityList) throws Exception
	{
		//keep a list of GroupAuthority instances that miss a reference which might be resolvable later
		List<GroupAuthority> groupAuthoritysMissingRefs = new ArrayList<GroupAuthority>();
	
		//update objects with foreign key values
		for(GroupAuthority o:  groupAuthorityList)
		{
			while(true){
				break;
			}
		}
		
		
		return groupAuthoritysMissingRefs;
	}
}

