
/* File:        org.molgenis.omx/model/UserAuthority.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.auth.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.auth.MolgenisUser;
import org.molgenis.omx.auth.UserAuthority;


/**
 * Reads UserAuthority from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class UserAuthorityEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(UserAuthorityEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'molgenisUser' (maps molgenisUser.Email -> molgenisUser.id)			
	final Map<String,Integer> molgenisUserKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports UserAuthority from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<UserAuthority> userAuthoritysMissingRefs = new ArrayList<UserAuthority>();
	
		//cache for objects to be imported from file (in batch)
		final List<UserAuthority> userAuthorityList = new ArrayList<UserAuthority>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			UserAuthority object = new UserAuthority();
			object.set(entity, false);				
			userAuthorityList.add(object);		
			
			//add to db when batch size is reached
			if(userAuthorityList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				userAuthoritysMissingRefs.addAll(resolveForeignKeys(db, userAuthorityList));
				userAuthorityList.removeAll(userAuthoritysMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
				db.update(userAuthorityList,dbAction, "id");
				
				//clear for next batch						
				userAuthorityList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!userAuthorityList.isEmpty())
		{
			total.set(total.get() + userAuthorityList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			userAuthoritysMissingRefs.addAll(resolveForeignKeys(db, userAuthorityList));
			userAuthorityList.removeAll(userAuthoritysMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
			db.update(userAuthorityList,dbAction, "id");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<UserAuthority> userAuthoritys = new ArrayList<UserAuthority>(userAuthoritysMissingRefs);

		int iterationCount = 0;

		do
		{
			userAuthoritysMissingRefs = resolveForeignKeys(db, userAuthoritysMissingRefs);
			
			LinkedHashSet<UserAuthority> differenceSet = new LinkedHashSet<UserAuthority>();
			Sets.symmetricDifference(new LinkedHashSet<UserAuthority>(userAuthoritys), new LinkedHashSet<UserAuthority>(userAuthoritysMissingRefs)).copyInto(differenceSet);
			List<UserAuthority> resolvableuserAuthoritys = new ArrayList<UserAuthority>(differenceSet);
			
			userAuthoritys.removeAll(resolvableuserAuthoritys);
			
			db.update(resolvableuserAuthoritys,dbAction, "id");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(UserAuthority blaat : userAuthoritysMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'userAuthority' entity failed:"
								+ "This is probably caused by a(n) 'userAuthority' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (userAuthoritysMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " userAuthority from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param userAuthorityList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<UserAuthority> resolveForeignKeys(Database db, List<UserAuthority> userAuthorityList) throws Exception
	{
		//keep a list of UserAuthority instances that miss a reference which might be resolvable later
		List<UserAuthority> userAuthoritysMissingRefs = new ArrayList<UserAuthority>();
	
		//resolve xref 'molgenisUser' from molgenisUser.Email -> molgenisUser.id
		for(UserAuthority o: userAuthorityList) 
		{
			if(o.getMolgenisUser_Email() != null) 
				molgenisUserKeymap.put(o.getMolgenisUser_Email(), null);
		}
		
		if(molgenisUserKeymap.size() > 0) 
		{
			List<MolgenisUser> molgenisUserList = db.query(MolgenisUser.class).in("Email",new ArrayList<Object>(molgenisUserKeymap.keySet())).find();
			for(MolgenisUser xref :  molgenisUserList)
			{
				molgenisUserKeymap.put(xref.getEmail(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(UserAuthority o:  userAuthorityList)
		{
			while(true){
				//update xref molgenisUser
				if(o.getMolgenisUser_Email() != null) 
				{
					String key = o.getMolgenisUser_Email();
					if(molgenisUserKeymap.get(key) == null)
					{
						throw new Exception("Import of 'UserAuthority' objects failed: cannot find MolgenisUser for molgenisUser_Email='"+o.getMolgenisUser_Email()+"'");
					}
					o.setMolgenisUser_Id(molgenisUserKeymap.get(key));
				}
				break;
			}
		}
		
		molgenisUserKeymap.clear();
		
		return userAuthoritysMissingRefs;
	}
}

