package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.auth.MolgenisGroup;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class MolgenisGroupService
{
	private static final Logger logger = Logger.getLogger(MolgenisGroupService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public MolgenisGroup create(MolgenisGroup molgenisGroup) throws DatabaseException
	{
		logger.debug("creating MolgenisGroup");
		db.add(molgenisGroup);
		return molgenisGroup;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public MolgenisGroup read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving MolgenisGroup");
		return db.findById(MolgenisGroup.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public void update(MolgenisGroup molgenisGroup) throws DatabaseException
	{
		logger.debug("updating MolgenisGroup");
		db.update(molgenisGroup);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting MolgenisGroup");
		MolgenisGroup molgenisGroup = db.findById(MolgenisGroup.class, id);
		return db.remove(molgenisGroup) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public Iterable<MolgenisGroup> readAll() throws DatabaseException
	{
		logger.debug("retrieving all MolgenisGroup instances");
		return db.find(MolgenisGroup.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public EntityPager<MolgenisGroup> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all MolgenisGroup instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(MolgenisGroup.class, queryRules.toArray(new QueryRule[0]));
		List<MolgenisGroup> molgenisGroupCollection = db.find(MolgenisGroup.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<MolgenisGroup>(start, num, count, molgenisGroupCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("MolgenisGroup");
	}
}