package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.auth.MolgenisUser;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class MolgenisUserService
{
	private static final Logger logger = Logger.getLogger(MolgenisUserService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public MolgenisUser create(MolgenisUser molgenisUser) throws DatabaseException
	{
		logger.debug("creating MolgenisUser");
		db.add(molgenisUser);
		return molgenisUser;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public MolgenisUser read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving MolgenisUser");
		return db.findById(MolgenisUser.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public void update(MolgenisUser molgenisUser) throws DatabaseException
	{
		logger.debug("updating MolgenisUser");
		db.update(molgenisUser);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting MolgenisUser");
		MolgenisUser molgenisUser = db.findById(MolgenisUser.class, id);
		return db.remove(molgenisUser) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public Iterable<MolgenisUser> readAll() throws DatabaseException
	{
		logger.debug("retrieving all MolgenisUser instances");
		return db.find(MolgenisUser.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public EntityPager<MolgenisUser> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all MolgenisUser instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(MolgenisUser.class, queryRules.toArray(new QueryRule[0]));
		List<MolgenisUser> molgenisUserCollection = db.find(MolgenisUser.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<MolgenisUser>(start, num, count, molgenisUserCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("MolgenisUser");
	}
}