
/* File:        org.molgenis.omx/model/MolgenisGroupMember.java
 * Copyright:   GBIC 2000-2013, all rights reserved
 * Date:        November 22, 2013
 * 
 * generator:   org.molgenis.generators.db.EntityImporterGen 4.0.0-testing
 *
 * 
 * THIS FILE HAS BEEN GENERATED, PLEASE DO NOT EDIT!
 */

package org.molgenis.omx.auth.db;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicInteger;

import org.apache.commons.lang3.StringUtils;
import com.google.common.collect.Sets;
import org.apache.log4j.Logger;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.Database.DatabaseAction;
import org.molgenis.framework.db.EntityImporter;
import org.molgenis.io.processor.LowerCaseProcessor;
import org.molgenis.io.TupleReader;
import org.molgenis.util.tuple.Tuple;

import org.molgenis.omx.auth.MolgenisUser;
import org.molgenis.omx.auth.MolgenisGroup;
import org.molgenis.omx.auth.MolgenisGroupMember;


/**
 * Reads MolgenisGroupMember from a delimited (csv) file, resolving xrefs to ids where needed, that is the tricky bit ;-)
 */
public class MolgenisGroupMemberEntityImporter implements EntityImporter
{
	private static final Logger logger = Logger.getLogger(MolgenisGroupMemberEntityImporter.class);
	
	private static int BATCH_SIZE = 10000;
	//foreign key map for xref 'molgenisUser' (maps molgenisUser.Email -> molgenisUser.id)			
	final Map<String,Integer> molgenisUserKeymap = new TreeMap<String,Integer>();	
			
	/**
	 * Imports MolgenisGroupMember from tab/comma delimited File
	 * @param db database to import into
	 * @param reader csv reader to load data from
	 * @param defaults to set default values for each row
	 * @param dbAction indicating wether to add,update,remove etc
	 * @param missingValues indicating what value in the csv is treated as 'null' (e.g. "" or "NA")
	 * @return number of elements imported
	 */
	@Override
	public int importEntity(Repository<? extends Entity> repository, Database db, DatabaseAction dbAction) throws IOException, DatabaseException 
	{
		//wrapper to count
		final AtomicInteger total = new AtomicInteger(0);
	try {
		//cache for entities of which xrefs couldn't be resolved (e.g. if there is a self-refence)
		//these entities can be updated with their xrefs in a second round when all entities are in the database
		List<MolgenisGroupMember> molgenisGroupMembersMissingRefs = new ArrayList<MolgenisGroupMember>();
	
		//cache for objects to be imported from file (in batch)
		final List<MolgenisGroupMember> molgenisGroupMemberList = new ArrayList<MolgenisGroupMember>(BATCH_SIZE); // FIXME
		
		for(Entity entity : repository)
		{
			// skip empty rows
			if (!hasValues(entity)) continue;
			
			//parse object, setting defaults and values from file
			MolgenisGroupMember object = new MolgenisGroupMember();
			object.set(entity, false);				
			molgenisGroupMemberList.add(object);		
			
			//add to db when batch size is reached
			if(molgenisGroupMemberList.size() == BATCH_SIZE)
			{
				//resolve foreign keys and copy those entities that could not be resolved to the missingRefs list
				molgenisGroupMembersMissingRefs.addAll(resolveForeignKeys(db, molgenisGroupMemberList));
				molgenisGroupMemberList.removeAll(molgenisGroupMembersMissingRefs);
				
				//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
				db.update(molgenisGroupMemberList,dbAction, "id");
				
				//clear for next batch						
				molgenisGroupMemberList.clear();		
				
				//keep count
				total.set(total.get() + BATCH_SIZE);
				
				db.getEntityManager().flush();
				db.getEntityManager().clear();		
			}
		}
			
		//add remaining elements to the database
		if(!molgenisGroupMemberList.isEmpty())
		{
			total.set(total.get() + molgenisGroupMemberList.size());
			
			//resolve foreign keys, again keeping track of those entities that could not be solved
			molgenisGroupMembersMissingRefs.addAll(resolveForeignKeys(db, molgenisGroupMemberList));
			molgenisGroupMemberList.removeAll(molgenisGroupMembersMissingRefs);
			
			//update objects in the database using xref_label defined secondary key(s) 'id' defined in xref_label
			db.update(molgenisGroupMemberList,dbAction, "id");
		}
		
		//Try to resolve FK's for entities until all are resolved or we have more then 100 iterations
		List<MolgenisGroupMember> molgenisGroupMembers = new ArrayList<MolgenisGroupMember>(molgenisGroupMembersMissingRefs);

		int iterationCount = 0;

		do
		{
			molgenisGroupMembersMissingRefs = resolveForeignKeys(db, molgenisGroupMembersMissingRefs);
			
			LinkedHashSet<MolgenisGroupMember> differenceSet = new LinkedHashSet<MolgenisGroupMember>();
			Sets.symmetricDifference(new LinkedHashSet<MolgenisGroupMember>(molgenisGroupMembers), new LinkedHashSet<MolgenisGroupMember>(molgenisGroupMembersMissingRefs)).copyInto(differenceSet);
			List<MolgenisGroupMember> resolvablemolgenisGroupMembers = new ArrayList<MolgenisGroupMember>(differenceSet);
			
			molgenisGroupMembers.removeAll(resolvablemolgenisGroupMembers);
			
			db.update(resolvablemolgenisGroupMembers,dbAction, "id");

			if (iterationCount++ > 100)
			{
			String identifier = "";
			String name = "";
				for(MolgenisGroupMember blaat : molgenisGroupMembersMissingRefs){
					identifier = blaat.getValues().get("Identifier").toString();
					name = blaat.getValues().get("Name").toString();
				}
				throw new Exception(
						"Import of 'molgenisGroupMember' entity failed:"
								+ "This is probably caused by a(n) 'molgenisGroupMember' that has a reference but that does not exist."
								+"(identifier:"+identifier+", name:"+name+")");		
			}
		}
		while (molgenisGroupMembersMissingRefs.size() > 0);

		logger.info("imported " + total.get() + " molgenisGroupMember from CSV");

		} catch(Exception e) {throw new IOException(e);}
		return total.get();
	}	
	
	private boolean hasValues(Entity entity)
	{
		for (String attributeName : entity.getAttributeNames())
		{
			if (entity.get(attributeName) != null) return true;
		}
		return false;
	}
	
	/**
	 * This method tries to resolve foreign keys (i.e. xref_field) based on the secondary key/key (i.e. xref_labels).
	 *
	 * @param db database
	 * @param molgenisGroupMemberList 
	 * @return the entities for which foreign keys cannot be resolved
	 */
	private List<MolgenisGroupMember> resolveForeignKeys(Database db, List<MolgenisGroupMember> molgenisGroupMemberList) throws Exception
	{
		//keep a list of MolgenisGroupMember instances that miss a reference which might be resolvable later
		List<MolgenisGroupMember> molgenisGroupMembersMissingRefs = new ArrayList<MolgenisGroupMember>();
	
		//resolve xref 'molgenisUser' from molgenisUser.Email -> molgenisUser.id
		for(MolgenisGroupMember o: molgenisGroupMemberList) 
		{
			if(o.getMolgenisUser_Email() != null) 
				molgenisUserKeymap.put(o.getMolgenisUser_Email(), null);
		}
		
		if(molgenisUserKeymap.size() > 0) 
		{
			List<MolgenisUser> molgenisUserList = db.query(MolgenisUser.class).in("Email",new ArrayList<Object>(molgenisUserKeymap.keySet())).find();
			for(MolgenisUser xref :  molgenisUserList)
			{
				molgenisUserKeymap.put(xref.getEmail(), xref.getId());
			}
		}
		//update objects with foreign key values
		for(MolgenisGroupMember o:  molgenisGroupMemberList)
		{
			while(true){
				//update xref molgenisUser
				if(o.getMolgenisUser_Email() != null) 
				{
					String key = o.getMolgenisUser_Email();
					if(molgenisUserKeymap.get(key) == null)
					{
						throw new Exception("Import of 'MolgenisGroupMember' objects failed: cannot find MolgenisUser for molgenisUser_Email='"+o.getMolgenisUser_Email()+"'");
					}
					o.setMolgenisUser_Id(molgenisUserKeymap.get(key));
				}
				break;
			}
		}
		
		molgenisUserKeymap.clear();
		
		return molgenisGroupMembersMissingRefs;
	}
}

