package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.auth.GroupAuthority;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class GroupAuthorityService
{
	private static final Logger logger = Logger.getLogger(GroupAuthorityService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public GroupAuthority create(GroupAuthority groupAuthority) throws DatabaseException
	{
		logger.debug("creating GroupAuthority");
		db.add(groupAuthority);
		return groupAuthority;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public GroupAuthority read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving GroupAuthority");
		return db.findById(GroupAuthority.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public void update(GroupAuthority groupAuthority) throws DatabaseException
	{
		logger.debug("updating GroupAuthority");
		db.update(groupAuthority);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting GroupAuthority");
		GroupAuthority groupAuthority = db.findById(GroupAuthority.class, id);
		return db.remove(groupAuthority) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public Iterable<GroupAuthority> readAll() throws DatabaseException
	{
		logger.debug("retrieving all GroupAuthority instances");
		return db.find(GroupAuthority.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public EntityPager<GroupAuthority> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all GroupAuthority instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(GroupAuthority.class, queryRules.toArray(new QueryRule[0]));
		List<GroupAuthority> groupAuthorityCollection = db.find(GroupAuthority.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<GroupAuthority>(start, num, count, groupAuthorityCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("GroupAuthority");
	}
}