package org.molgenis.service;

import java.util.List;
import java.util.ArrayList;

import org.apache.log4j.Logger;
import org.molgenis.framework.db.Database;
import org.molgenis.framework.db.DatabaseException;
import org.molgenis.framework.db.QueryRule;
import org.molgenis.framework.db.QueryRule.Operator;
import org.molgenis.omx.auth.MolgenisGroupMember;
import org.molgenis.model.elements.Entity;
import org.molgenis.util.EntityPager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Lazy;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;

@Lazy
@Service
public class MolgenisGroupMemberService
{
	private static final Logger logger = Logger.getLogger(MolgenisGroupMemberService.class);

	@Autowired
	@Qualifier("database")
	private Database db;

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public MolgenisGroupMember create(MolgenisGroupMember molgenisGroupMember) throws DatabaseException
	{
		logger.debug("creating MolgenisGroupMember");
		db.add(molgenisGroupMember);
		return molgenisGroupMember;
	}

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public MolgenisGroupMember read(Integer id) throws DatabaseException
	{
		logger.debug("retrieving MolgenisGroupMember");
		return db.findById(MolgenisGroupMember.class, id);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public void update(MolgenisGroupMember molgenisGroupMember) throws DatabaseException
	{
		logger.debug("updating MolgenisGroupMember");
		db.update(molgenisGroupMember);
	}

	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public boolean deleteById(Integer id) throws DatabaseException
	{
		logger.debug("deleting MolgenisGroupMember");
		MolgenisGroupMember molgenisGroupMember = db.findById(MolgenisGroupMember.class, id);
		return db.remove(molgenisGroupMember) == 1;
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public Iterable<MolgenisGroupMember> readAll() throws DatabaseException
	{
		logger.debug("retrieving all MolgenisGroupMember instances");
		return db.find(MolgenisGroupMember.class);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public EntityPager<MolgenisGroupMember> readAll(int start, int num, List<QueryRule> queryRules) throws DatabaseException
	{
		logger.debug("retrieving all MolgenisGroupMember instances");
		if (queryRules == null) queryRules = new ArrayList<QueryRule>();
		queryRules.add(new QueryRule(Operator.OFFSET, start));
		queryRules.add(new QueryRule(Operator.LIMIT, num));
		int count = db.count(MolgenisGroupMember.class, queryRules.toArray(new QueryRule[0]));
		List<MolgenisGroupMember> molgenisGroupMemberCollection = db.find(MolgenisGroupMember.class, queryRules.toArray(new QueryRule[0]));
		return new EntityPager<MolgenisGroupMember>(start, num, count, molgenisGroupMemberCollection);
	}
	
	@PreAuthorize("hasAnyRole('ROLE_SU')")
	public Entity getEntity() throws DatabaseException
	{
		return db.getMetaData().getEntity("MolgenisGroupMember");
	}
}