/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.molgenis.auth.MolgenisUser;
import org.molgenis.security.user.MolgenisUserService;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.web.filter.GenericFilterBean;

public class MolgenisChangePasswordFilter
extends GenericFilterBean {
    private final MolgenisUserService molgenisUserService;
    private final RedirectStrategy redirectStrategy;

    public MolgenisChangePasswordFilter(MolgenisUserService molgenisUserService, RedirectStrategy redirectStrategy) {
        this.molgenisUserService = molgenisUserService;
        this.redirectStrategy = redirectStrategy;
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (!(authentication == null || !authentication.isAuthenticated() || authentication.getName().equals("anonymous") || httpRequest.getRequestURI().toLowerCase().endsWith("/account/password/change".toLowerCase()) || httpRequest.getRequestURI().toLowerCase().startsWith("/img/") || httpRequest.getRequestURI().toLowerCase().startsWith("/css/") || httpRequest.getRequestURI().toLowerCase().startsWith("/js/"))) {
            MolgenisUser user = this.molgenisUserService.getUser(authentication.getName());
            if (user == null) {
                throw new RuntimeException("Unknown username [" + authentication.getName() + "]");
            }
            if (user.isChangePassword() != null && user.isChangePassword().booleanValue()) {
                this.redirectStrategy.sendRedirect(httpRequest, httpResponse, "/account/password/change");
                return;
            }
        }
        chain.doFilter(request, response);
    }
}

