/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.permission;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.molgenis.security.permission.Permission;

public class Permissions {
    private String userId;
    private String groupId;
    private Map<String, String> entityIds;
    private Map<String, List<Permission>> userPermissionMap;
    private Map<String, List<Permission>> groupPermissionMap;
    private Map<String, List<Permission>> hierarchyPermissionMap;

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public Map<String, String> getEntityIds() {
        return this.entityIds;
    }

    public void setEntityIds(Map<String, String> entityIds) {
        this.entityIds = entityIds;
    }

    public Map<String, List<Permission>> getUserPermissions() {
        return this.userPermissionMap != null ? this.userPermissionMap : Collections.emptyMap();
    }

    public void addUserPermission(String pluginId, Permission pluginPermission) {
        List<Permission> pluginPermissions;
        if (this.userPermissionMap == null) {
            this.userPermissionMap = new HashMap<String, List<Permission>>();
        }
        if ((pluginPermissions = this.userPermissionMap.get(pluginId)) == null) {
            pluginPermissions = new ArrayList<Permission>();
            this.userPermissionMap.put(pluginId, pluginPermissions);
        }
        pluginPermissions.add(pluginPermission);
    }

    public Map<String, List<Permission>> getGroupPermissions() {
        return this.groupPermissionMap != null ? this.groupPermissionMap : Collections.emptyMap();
    }

    public void addGroupPermission(String pluginId, Permission pluginPermission) {
        List<Permission> pluginPermissions;
        if (this.groupPermissionMap == null) {
            this.groupPermissionMap = new HashMap<String, List<Permission>>();
        }
        if ((pluginPermissions = this.groupPermissionMap.get(pluginId)) == null) {
            pluginPermissions = new ArrayList<Permission>();
            this.groupPermissionMap.put(pluginId, pluginPermissions);
        }
        pluginPermissions.add(pluginPermission);
    }

    public Map<String, List<Permission>> getHierarchyPermissionMap() {
        return this.hierarchyPermissionMap;
    }

    public void addHierarchyPermission(String pluginId, Permission pluginPermission) {
        List<Permission> pluginPermissions;
        if (this.hierarchyPermissionMap == null) {
            this.hierarchyPermissionMap = new HashMap<String, List<Permission>>();
        }
        if ((pluginPermissions = this.hierarchyPermissionMap.get(pluginId)) == null) {
            pluginPermissions = new ArrayList<Permission>();
            this.hierarchyPermissionMap.put(pluginId, pluginPermissions);
        }
        pluginPermissions.add(pluginPermission);
    }

    public void sort() {
        if (this.userPermissionMap != null) {
            for (List<Permission> pluginPermissions : this.userPermissionMap.values()) {
                if (pluginPermissions.size() <= 1) continue;
                Collections.sort(pluginPermissions, new Comparator<Permission>(){

                    @Override
                    public int compare(Permission o1, Permission o2) {
                        String group1 = o1.getGroup();
                        String group2 = o2.getGroup();
                        if (group1 == null) {
                            return group2 == null ? 0 : -1;
                        }
                        return group2 == null ? 1 : group1.compareTo(group2);
                    }
                });
            }
        }
        if (this.groupPermissionMap != null) {
            for (List<Permission> pluginPermissions : this.groupPermissionMap.values()) {
                if (pluginPermissions.size() <= 1) continue;
                Collections.sort(pluginPermissions, new Comparator<Permission>(){

                    @Override
                    public int compare(Permission o1, Permission o2) {
                        String group1 = o1.getGroup();
                        String group2 = o2.getGroup();
                        if (group1 == null) {
                            return group2 == null ? 0 : -1;
                        }
                        return group2 == null ? 1 : group1.compareTo(group2);
                    }
                });
            }
        }
    }
}

