/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.account;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.auth.MolgenisGroup;
import org.molgenis.auth.MolgenisGroupMember;
import org.molgenis.auth.MolgenisUser;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.settings.AppSettings;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.security.account.AccountService;
import org.molgenis.security.account.EmailAlreadyExistsException;
import org.molgenis.security.account.UsernameAlreadyExistsException;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.user.MolgenisUserException;
import org.molgenis.security.user.MolgenisUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailException;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountServiceImpl
implements AccountService {
    private static final Logger LOG = LoggerFactory.getLogger(AccountServiceImpl.class);
    private final DataService dataService;
    private final JavaMailSender mailSender;
    private final MolgenisUserService molgenisUserService;
    private final AppSettings appSettings;

    @Autowired
    public AccountServiceImpl(DataService dataService, JavaMailSender mailSender, MolgenisUserService molgenisUserService, AppSettings appSettings) {
        this.dataService = Objects.requireNonNull(dataService);
        this.mailSender = Objects.requireNonNull(mailSender);
        this.molgenisUserService = Objects.requireNonNull(molgenisUserService);
        this.appSettings = Objects.requireNonNull(appSettings);
    }

    @Override
    @RunAsSystem
    @Transactional
    public void createUser(MolgenisUser molgenisUser, String baseActivationUri) throws UsernameAlreadyExistsException, EmailAlreadyExistsException {
        List<String> activationEmailAddresses;
        if (this.molgenisUserService.getUser(molgenisUser.getUsername()) != null) {
            throw new UsernameAlreadyExistsException("Username '" + molgenisUser.getUsername() + "' already exists.");
        }
        if (this.molgenisUserService.getUserByEmail(molgenisUser.getEmail()) != null) {
            throw new EmailAlreadyExistsException("Email '" + molgenisUser.getEmail() + "' is already registered.");
        }
        String activationCode = UUID.randomUUID().toString();
        if (this.appSettings.getSignUpModeration()) {
            activationEmailAddresses = this.molgenisUserService.getSuEmailAddresses();
            if (activationEmailAddresses == null || activationEmailAddresses.isEmpty()) {
                throw new MolgenisDataException("Administrator account is missing required email address");
            }
        } else {
            String activationEmailAddress = molgenisUser.getEmail();
            if (activationEmailAddress == null || activationEmailAddress.isEmpty()) {
                throw new MolgenisDataException("User '" + molgenisUser.getUsername() + "' is missing required email address");
            }
            activationEmailAddresses = Arrays.asList(activationEmailAddress);
        }
        molgenisUser.setActivationCode(activationCode);
        molgenisUser.setActive(Boolean.valueOf(false));
        this.dataService.add("molgenisUser", (Entity)molgenisUser);
        LOG.debug("created user " + molgenisUser.getUsername());
        MolgenisGroup group = (MolgenisGroup)this.dataService.findOne("molgenisGroup", new QueryImpl().eq("name", (Object)"All Users"), MolgenisGroup.class);
        MolgenisGroupMember molgenisGroupMember = null;
        if (group != null) {
            molgenisGroupMember = new MolgenisGroupMember();
            molgenisGroupMember.setMolgenisGroup(group);
            molgenisGroupMember.setMolgenisUser(molgenisUser);
            this.dataService.add("MolgenisGroupMember", (Entity)molgenisGroupMember);
        }
        URI activationUri = URI.create(baseActivationUri + '/' + activationCode);
        try {
            SimpleMailMessage mailMessage = new SimpleMailMessage();
            mailMessage.setTo(activationEmailAddresses.toArray(new String[0]));
            mailMessage.setSubject("User registration for " + this.appSettings.getTitle());
            mailMessage.setText(this.createActivationEmailText(molgenisUser, activationUri));
            this.mailSender.send(mailMessage);
        }
        catch (MailException mce) {
            LOG.error("Could not send signup mail", (Throwable)mce);
            if (molgenisGroupMember != null) {
                this.dataService.delete("MolgenisGroupMember", (Entity)molgenisGroupMember);
            }
            if (molgenisUser != null) {
                this.dataService.delete("molgenisUser", (Entity)molgenisUser);
            }
            throw new MolgenisUserException("An error occurred. Please contact the administrator. You are not signed up!");
        }
        LOG.debug("send activation email for user " + molgenisUser.getUsername() + " to " + StringUtils.join(activationEmailAddresses, (char)','));
    }

    @Override
    @RunAsSystem
    public void activateUser(String activationCode) {
        MolgenisUser molgenisUser = (MolgenisUser)this.dataService.findOne("molgenisUser", new QueryImpl().eq("active", (Object)false).and().eq("activationCode", (Object)activationCode), MolgenisUser.class);
        if (molgenisUser == null) {
            throw new MolgenisUserException("Invalid activation code or account already activated.");
        }
        molgenisUser.setActive(Boolean.valueOf(true));
        this.dataService.update("molgenisUser", (Entity)molgenisUser);
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setTo(molgenisUser.getEmail());
        mailMessage.setSubject("Your registration request for " + this.appSettings.getTitle());
        mailMessage.setText(this.createActivatedEmailText(molgenisUser, this.appSettings.getTitle()));
        this.mailSender.send(mailMessage);
    }

    @Override
    @RunAsSystem
    public void changePassword(String username, String newPassword) {
        MolgenisUser molgenisUser = (MolgenisUser)this.dataService.findOne("molgenisUser", new QueryImpl().eq("username", (Object)username), MolgenisUser.class);
        if (molgenisUser == null) {
            throw new MolgenisUserException("Unknown user [" + username + "]");
        }
        molgenisUser.setPassword(newPassword);
        molgenisUser.setChangePassword(Boolean.valueOf(false));
        this.dataService.update("molgenisUser", (Entity)molgenisUser);
        LOG.info("Changed password of user [" + username + "]");
    }

    @Override
    @RunAsSystem
    public void resetPassword(String userEmail) {
        MolgenisUser molgenisUser = (MolgenisUser)this.dataService.findOne("molgenisUser", new QueryImpl().eq("Email", (Object)userEmail), MolgenisUser.class);
        if (molgenisUser == null) {
            throw new MolgenisUserException("Invalid email address.");
        }
        String newPassword = UUID.randomUUID().toString().substring(0, 8);
        molgenisUser.setPassword(newPassword);
        molgenisUser.setChangePassword(Boolean.valueOf(true));
        this.dataService.update("molgenisUser", (Entity)molgenisUser);
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setTo(molgenisUser.getEmail());
        mailMessage.setSubject("Your new password request");
        mailMessage.setText(this.createPasswordResettedEmailText(newPassword));
        this.mailSender.send(mailMessage);
    }

    private String createActivationEmailText(MolgenisUser user, URI activationUri) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("User registration for ").append(this.appSettings.getTitle()).append('\n');
        strBuilder.append("User name: ").append(user.getUsername()).append(" Full name: ").append(user.getFirstName());
        strBuilder.append(' ').append(user.getLastName()).append('\n');
        strBuilder.append("In order to activate the user visit the following URL:").append('\n');
        strBuilder.append(activationUri).append('\n').append('\n');
        return strBuilder.toString();
    }

    private String createActivatedEmailText(MolgenisUser user, String appName) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("Dear ").append(user.getFirstName()).append(" ").append(user.getLastName()).append(",\n\n");
        strBuilder.append("your registration request for ").append(appName).append(" was approved.\n");
        strBuilder.append("Your account is now active.\n");
        return strBuilder.toString();
    }

    private String createPasswordResettedEmailText(String newPassword) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("Somebody, probably you, requested a new password for ").append(this.appSettings.getTitle()).append(".\n");
        strBuilder.append("The new password is: ").append(newPassword).append('\n');
        strBuilder.append("Note: we strongly recommend you reset your password after log-in!");
        return strBuilder.toString();
    }
}

