/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.owned;

import java.io.IOException;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import org.molgenis.data.AggregateQuery;
import org.molgenis.data.AggregateResult;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityListener;
import org.molgenis.data.EntityMetaData;
import org.molgenis.data.Fetch;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.util.EntityUtils;

public class OwnedEntityRepositoryDecorator
implements Repository {
    private final Repository decoratedRepo;

    public OwnedEntityRepositoryDecorator(Repository decoratedRepo) {
        this.decoratedRepo = Objects.requireNonNull(decoratedRepo);
    }

    public Iterator<Entity> iterator() {
        if (this.mustAddRowLevelSecurity()) {
            return this.findAll((Query)new QueryImpl()).iterator();
        }
        return this.decoratedRepo.iterator();
    }

    public void close() throws IOException {
        this.decoratedRepo.close();
    }

    public Set<RepositoryCapability> getCapabilities() {
        return this.decoratedRepo.getCapabilities();
    }

    public String getName() {
        return this.decoratedRepo.getName();
    }

    public EntityMetaData getEntityMetaData() {
        return this.decoratedRepo.getEntityMetaData();
    }

    public long count() {
        if (this.mustAddRowLevelSecurity()) {
            return this.count((Query)new QueryImpl());
        }
        return this.decoratedRepo.count();
    }

    public Query query() {
        return this.decoratedRepo.query();
    }

    public long count(Query q) {
        if (this.mustAddRowLevelSecurity()) {
            this.addRowLevelSecurity(q);
        }
        return this.decoratedRepo.count(q);
    }

    public Stream<Entity> findAll(Query q) {
        if (this.mustAddRowLevelSecurity()) {
            this.addRowLevelSecurity(q);
        }
        return this.decoratedRepo.findAll(q);
    }

    public Entity findOne(Query q) {
        if (this.mustAddRowLevelSecurity()) {
            this.addRowLevelSecurity(q);
        }
        return this.decoratedRepo.findOne(q);
    }

    public Entity findOne(Object id) {
        Entity e = this.decoratedRepo.findOne(id);
        if (this.mustAddRowLevelSecurity() && !this.currentUserIsOwner(e)) {
            return null;
        }
        return e;
    }

    public Entity findOne(Object id, Fetch fetch) {
        if (fetch != null) {
            fetch.field("ownerUsername");
        }
        Entity e = this.decoratedRepo.findOne(id, fetch);
        if (this.mustAddRowLevelSecurity() && !this.currentUserIsOwner(e)) {
            return null;
        }
        return e;
    }

    public Stream<Entity> findAll(Stream<Object> ids) {
        Stream<Entity> entities = this.decoratedRepo.findAll(ids);
        if (this.mustAddRowLevelSecurity()) {
            entities = entities.filter(this::currentUserIsOwner);
        }
        return entities;
    }

    public Stream<Entity> findAll(Stream<Object> ids, Fetch fetch) {
        if (fetch != null) {
            fetch.field("ownerUsername");
        }
        Stream<Entity> entities = this.decoratedRepo.findAll(ids, fetch);
        if (this.mustAddRowLevelSecurity()) {
            entities = entities.filter(this::currentUserIsOwner);
        }
        return entities;
    }

    public AggregateResult aggregate(AggregateQuery aggregateQuery) {
        if (this.mustAddRowLevelSecurity()) {
            this.addRowLevelSecurity(aggregateQuery.getQuery());
        }
        return this.decoratedRepo.aggregate(aggregateQuery);
    }

    public void update(Entity entity) {
        if (this.mustAddRowLevelSecurity()) {
            entity.set("ownerUsername", (Object)SecurityUtils.getCurrentUsername());
        }
        this.decoratedRepo.update(entity);
    }

    public void update(Stream<? extends Entity> entities) {
        if (this.mustAddRowLevelSecurity()) {
            entities = entities.filter(entity -> {
                entity.set("ownerUsername", (Object)SecurityUtils.getCurrentUsername());
                return true;
            });
        }
        this.decoratedRepo.update(entities);
    }

    public void delete(Entity entity) {
        if (this.mustAddRowLevelSecurity() && !this.currentUserIsOwner(entity)) {
            return;
        }
        this.decoratedRepo.delete(entity);
    }

    public void delete(Stream<? extends Entity> entities) {
        if (this.mustAddRowLevelSecurity()) {
            entities = entities.filter(this::currentUserIsOwner);
        }
        this.decoratedRepo.delete(entities);
    }

    public void deleteById(Object id) {
        Entity entity;
        if (this.mustAddRowLevelSecurity() && (entity = this.findOne(id)) != null && !this.currentUserIsOwner(entity)) {
            return;
        }
        this.decoratedRepo.deleteById(id);
    }

    public void deleteById(Stream<Object> ids) {
        if (this.mustAddRowLevelSecurity()) {
            this.delete(this.decoratedRepo.findAll(ids));
        } else {
            this.decoratedRepo.deleteById(ids);
        }
    }

    public void deleteAll() {
        if (this.mustAddRowLevelSecurity()) {
            this.delete(this.decoratedRepo.stream());
        } else {
            this.decoratedRepo.deleteAll();
        }
    }

    public void add(Entity entity) {
        if (this.mustAddRowLevelSecurity()) {
            entity.set("ownerUsername", (Object)SecurityUtils.getCurrentUsername());
        }
        this.decoratedRepo.add(entity);
    }

    public Integer add(Stream<? extends Entity> entities) {
        if (this.mustAddRowLevelSecurity()) {
            entities = entities.map(entity -> {
                entity.set("ownerUsername", (Object)SecurityUtils.getCurrentUsername());
                return entity;
            });
        }
        return this.decoratedRepo.add(entities);
    }

    public void flush() {
        this.decoratedRepo.flush();
    }

    public void clearCache() {
        this.decoratedRepo.clearCache();
    }

    private boolean mustAddRowLevelSecurity() {
        if (SecurityUtils.currentUserIsSu()) {
            return false;
        }
        return EntityUtils.doesExtend((EntityMetaData)this.getEntityMetaData(), (String)"Owned");
    }

    private void addRowLevelSecurity(Query q) {
        String user = SecurityUtils.getCurrentUsername();
        if (user != null) {
            if (!q.getRules().isEmpty()) {
                q.and();
            }
            q.eq("ownerUsername", (Object)user);
        }
    }

    private String getOwnerUserName(Entity questionnaire) {
        return questionnaire.getString("ownerUsername");
    }

    public void create() {
        this.decoratedRepo.create();
    }

    public void drop() {
        this.decoratedRepo.drop();
    }

    public void rebuildIndex() {
        this.decoratedRepo.rebuildIndex();
    }

    public void addEntityListener(EntityListener entityListener) {
        this.decoratedRepo.addEntityListener(entityListener);
    }

    public void removeEntityListener(EntityListener entityListener) {
        this.decoratedRepo.removeEntityListener(entityListener);
    }

    private boolean currentUserIsOwner(Entity entity) {
        return SecurityUtils.getCurrentUsername().equals(this.getOwnerUserName(entity));
    }
}

