/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.user;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.molgenis.auth.Authority;
import org.molgenis.auth.GroupAuthority;
import org.molgenis.auth.MolgenisGroup;
import org.molgenis.auth.MolgenisGroupMember;
import org.molgenis.auth.MolgenisUser;
import org.molgenis.auth.UserAuthority;
import org.molgenis.data.DataService;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.security.core.runas.RunAsSystem;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;

public class MolgenisUserDetailsService
implements UserDetailsService {
    private final DataService dataService;
    private final GrantedAuthoritiesMapper grantedAuthoritiesMapper;

    @Autowired
    public MolgenisUserDetailsService(DataService dataService, GrantedAuthoritiesMapper grantedAuthoritiesMapper) {
        if (dataService == null) {
            throw new IllegalArgumentException("DataService is null");
        }
        if (grantedAuthoritiesMapper == null) {
            throw new IllegalArgumentException("Granted authorities mapper is null");
        }
        this.dataService = dataService;
        this.grantedAuthoritiesMapper = grantedAuthoritiesMapper;
    }

    @RunAsSystem
    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
        try {
            MolgenisUser user = (MolgenisUser)this.dataService.findOne("molgenisUser", new QueryImpl().eq("username", (Object)username), MolgenisUser.class);
            if (user == null) {
                throw new UsernameNotFoundException("unknown user '" + username + "'");
            }
            Collection<? extends GrantedAuthority> authorities = this.getAuthorities(user);
            return new User(user.getUsername(), user.getPassword(), user.isActive().booleanValue(), true, true, true, authorities);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public Collection<? extends GrantedAuthority> getAuthorities(MolgenisUser user) {
        List<UserAuthority> authorities = this.getUserAuthorities(user);
        List grantedAuthorities = authorities != null ? Lists.transform(authorities, (Function)new Function<Authority, GrantedAuthority>(){

            public GrantedAuthority apply(Authority authority) {
                return new SimpleGrantedAuthority(authority.getRole());
            }
        }) : null;
        List<GroupAuthority> groupAuthorities = this.getGroupAuthorities(user);
        List grantedGroupAuthorities = groupAuthorities != null ? Lists.transform(groupAuthorities, (Function)new Function<GroupAuthority, GrantedAuthority>(){

            public GrantedAuthority apply(GroupAuthority groupAuthority) {
                return new SimpleGrantedAuthority(groupAuthority.getRole());
            }
        }) : null;
        HashSet<SimpleGrantedAuthority> allGrantedAuthorities = new HashSet<SimpleGrantedAuthority>();
        if (grantedAuthorities != null) {
            allGrantedAuthorities.addAll(grantedAuthorities);
        }
        if (grantedGroupAuthorities != null) {
            allGrantedAuthorities.addAll(grantedGroupAuthorities);
        }
        if (user.isSuperuser() != null && user.isSuperuser().booleanValue()) {
            allGrantedAuthorities.add(new SimpleGrantedAuthority("ROLE_SU"));
        }
        return this.grantedAuthoritiesMapper.mapAuthorities(allGrantedAuthorities);
    }

    private List<UserAuthority> getUserAuthorities(MolgenisUser molgenisUser) {
        return this.dataService.findAll("UserAuthority", new QueryImpl().eq("molgenisUser", (Object)molgenisUser), UserAuthority.class).collect(Collectors.toList());
    }

    private List<GroupAuthority> getGroupAuthorities(MolgenisUser molgenisUser) {
        List groupMembers = this.dataService.findAll("MolgenisGroupMember", new QueryImpl().eq("molgenisUser", (Object)molgenisUser), MolgenisGroupMember.class).collect(Collectors.toList());
        if (!groupMembers.isEmpty()) {
            List molgenisGroups = Lists.transform(groupMembers, (Function)new Function<MolgenisGroupMember, MolgenisGroup>(){

                public MolgenisGroup apply(MolgenisGroupMember molgenisGroupMember) {
                    return molgenisGroupMember.getMolgenisGroup();
                }
            });
            return this.dataService.findAll("GroupAuthority", new QueryImpl().in("molgenisGroup", (Iterable)molgenisGroups), GroupAuthority.class).collect(Collectors.toList());
        }
        return null;
    }
}

