/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.molgenis.security.core.utils.SecurityUtils;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.util.matcher.ELRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class AjaxAwareLoginUrlAuthenticationEntryPoint
extends LoginUrlAuthenticationEntryPoint {
    private static final RequestMatcher requestMatcher = new ELRequestMatcher("hasHeader('X-Requested-With','XMLHttpRequest')");

    public AjaxAwareLoginUrlAuthenticationEntryPoint(String loginFormUrl) {
        super(loginFormUrl);
    }

    public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
        if (this.isPreflight(request)) {
            response.setStatus(204);
        } else if (this.isRestRequest(request)) {
            if (SecurityUtils.isSessionExpired((HttpServletRequest)request)) {
                request.getSession().setAttribute("sessionExpired", (Object)true);
            }
            response.sendError(401, "Unauthorized");
        } else {
            if (SecurityUtils.isSessionExpired((HttpServletRequest)request)) {
                request.getSession().setAttribute("sessionExpired", (Object)true);
            }
            super.commence(request, response, authException);
        }
    }

    private boolean isPreflight(HttpServletRequest request) {
        return "OPTIONS".equals(request.getMethod());
    }

    protected boolean isRestRequest(HttpServletRequest request) {
        return requestMatcher.matches(request);
    }
}

