/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security;

import java.io.IOException;
import java.util.Collection;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.molgenis.security.core.runas.SystemSecurityToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.security.authentication.AnonymousAuthenticationToken;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.util.Assert;
import org.springframework.web.filter.GenericFilterBean;

public class MolgenisAnonymousAuthenticationFilter
extends GenericFilterBean
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(MolgenisAnonymousAuthenticationFilter.class);
    private AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private final String key;
    private final Object principal;
    private final UserDetailsService userDetailsService;

    public MolgenisAnonymousAuthenticationFilter(String key, Object principal, UserDetailsService userDetailsService) {
        this.key = key;
        this.principal = principal;
        this.userDetailsService = userDetailsService;
    }

    public void afterPropertiesSet() {
        Assert.hasLength((String)this.key);
        Assert.notNull((Object)this.principal, (String)"Anonymous authentication principal must be set");
        Assert.notNull((Object)this.userDetailsService, (String)"User details service must be set");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        if (SecurityContextHolder.getContext().getAuthentication() == null) {
            SecurityContextHolder.getContext().setAuthentication(this.createAuthentication((HttpServletRequest)req));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Populated SecurityContextHolder with anonymous token: '" + SecurityContextHolder.getContext().getAuthentication() + "'");
            }
        } else if (LOG.isTraceEnabled()) {
            LOG.trace("SecurityContextHolder not populated with anonymous token, as it already contained: '{}'", (Object)SecurityContextHolder.getContext().getAuthentication());
        }
        chain.doFilter(req, res);
    }

    protected Authentication createAuthentication(HttpServletRequest request) {
        AnonymousAuthenticationToken auth = new AnonymousAuthenticationToken(this.key, this.principal, this.getAuthorities());
        auth.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        return auth;
    }

    public void setAuthenticationDetailsSource(AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource) {
        Assert.notNull(authenticationDetailsSource, (String)"AuthenticationDetailsSource required");
        this.authenticationDetailsSource = authenticationDetailsSource;
    }

    public Object getPrincipal() {
        return this.principal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<? extends GrantedAuthority> getAuthorities() {
        SecurityContext origCtx = SecurityContextHolder.getContext();
        try {
            SecurityContextHolder.setContext((SecurityContext)SecurityContextHolder.createEmptyContext());
            SecurityContextHolder.getContext().setAuthentication((Authentication)new SystemSecurityToken());
            UserDetails user = this.userDetailsService.loadUserByUsername("anonymous");
            if (user == null) {
                throw new RuntimeException("user with name 'anonymous' does not exist");
            }
            Collection collection = user.getAuthorities();
            return collection;
        }
        finally {
            SecurityContextHolder.setContext((SecurityContext)origCtx);
        }
    }
}

