/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.permission;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.molgenis.auth.Authority;
import org.molgenis.auth.GroupAuthority;
import org.molgenis.auth.MolgenisGroup;
import org.molgenis.auth.MolgenisGroupMember;
import org.molgenis.auth.MolgenisUser;
import org.molgenis.auth.UserAuthority;
import org.molgenis.data.DataService;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.framework.ui.MolgenisPlugin;
import org.molgenis.framework.ui.MolgenisPluginRegistry;
import org.molgenis.security.permission.Permission;
import org.molgenis.security.permission.PermissionManagerService;
import org.molgenis.security.permission.Permissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PermissionManagerServiceImpl
implements PermissionManagerService {
    private final DataService dataService;
    private final MolgenisPluginRegistry molgenisPluginRegistry;
    private final GrantedAuthoritiesMapper grantedAuthoritiesMapper;

    @Autowired
    public PermissionManagerServiceImpl(DataService dataService, MolgenisPluginRegistry molgenisPluginRegistry, GrantedAuthoritiesMapper grantedAuthoritiesMapper) {
        if (dataService == null) {
            throw new IllegalArgumentException("DataService is null");
        }
        if (molgenisPluginRegistry == null) {
            throw new IllegalArgumentException("Molgenis plugin registry is null");
        }
        if (grantedAuthoritiesMapper == null) {
            throw new IllegalArgumentException("Granted authorities mapper is null");
        }
        this.dataService = dataService;
        this.molgenisPluginRegistry = molgenisPluginRegistry;
        this.grantedAuthoritiesMapper = grantedAuthoritiesMapper;
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional(readOnly=true)
    public List<MolgenisUser> getUsers() {
        return this.dataService.findAll("molgenisUser", MolgenisUser.class).collect(Collectors.toList());
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional(readOnly=true)
    public List<MolgenisGroup> getGroups() {
        return this.dataService.findAll("molgenisGroup", MolgenisGroup.class).collect(Collectors.toList());
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    public List<MolgenisPlugin> getPlugins() {
        return Lists.newArrayList((Iterable)this.molgenisPluginRegistry);
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    public List<String> getEntityClassIds() {
        return this.dataService.getEntityNames().collect(Collectors.toList());
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional(readOnly=true)
    public Permissions getGroupPluginPermissions(String groupId) {
        MolgenisGroup molgenisGroup = (MolgenisGroup)this.dataService.findOne("molgenisGroup", (Object)groupId, MolgenisGroup.class);
        if (molgenisGroup == null) {
            throw new RuntimeException("unknown group id [" + groupId + "]");
        }
        List<Authority> groupPermissions = this.getGroupPermissions(molgenisGroup);
        Permissions permissions = this.createPermissions(groupPermissions, "ROLE_PLUGIN_");
        permissions.setGroupId(groupId);
        return permissions;
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional(readOnly=true)
    public Permissions getGroupEntityClassPermissions(String groupId) {
        MolgenisGroup molgenisGroup = (MolgenisGroup)this.dataService.findOne("molgenisGroup", (Object)groupId, MolgenisGroup.class);
        if (molgenisGroup == null) {
            throw new RuntimeException("unknown group id [" + groupId + "]");
        }
        List<Authority> groupPermissions = this.getGroupPermissions(molgenisGroup);
        Permissions permissions = this.createPermissions(groupPermissions, "ROLE_ENTITY_");
        permissions.setGroupId(groupId);
        return permissions;
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional(readOnly=true)
    public Permissions getUserPluginPermissions(String userId) {
        List<? extends Authority> userPermissions = this.getUserPermissions(userId);
        Permissions permissions = this.createPermissions(userPermissions, "ROLE_PLUGIN_");
        permissions.setUserId(userId);
        return permissions;
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional(readOnly=true)
    public Permissions getUserEntityClassPermissions(String userId) {
        List<? extends Authority> userPermissions = this.getUserPermissions(userId);
        Permissions permissions = this.createPermissions(userPermissions, "ROLE_ENTITY_");
        permissions.setUserId(userId);
        return permissions;
    }

    private List<? extends Authority> getUserPermissions(String userId) {
        return this.getUserPermissions(userId, null);
    }

    private List<? extends Authority> getUserPermissions(String userId, String authorityPrefix) {
        List molgenisGroups;
        List<Authority> groupAuthorities;
        MolgenisUser molgenisUser = (MolgenisUser)this.dataService.findOne("molgenisUser", (Object)userId, MolgenisUser.class);
        if (molgenisUser == null) {
            throw new RuntimeException("unknown user id [" + userId + "]");
        }
        List<Authority> userPermissions = this.getUserPermissions(molgenisUser, authorityPrefix);
        List groupMembers = this.dataService.findAll("MolgenisGroupMember", new QueryImpl().eq("molgenisUser", (Object)molgenisUser), MolgenisGroupMember.class).collect(Collectors.toList());
        if (!groupMembers.isEmpty() && (groupAuthorities = this.getGroupPermissions(molgenisGroups = Lists.transform(groupMembers, (Function)new Function<MolgenisGroupMember, MolgenisGroup>(){

            public MolgenisGroup apply(MolgenisGroupMember molgenisGroupMember) {
                return molgenisGroupMember.getMolgenisGroup();
            }
        }), authorityPrefix)) != null && !groupAuthorities.isEmpty()) {
            userPermissions.addAll(groupAuthorities);
        }
        return userPermissions;
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional
    public void replaceGroupPluginPermissions(List<GroupAuthority> pluginAuthorities, String groupId) {
        this.replaceGroupPermissions(pluginAuthorities, groupId, "ROLE_PLUGIN_");
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional
    public void replaceGroupEntityClassPermissions(List<GroupAuthority> entityAuthorities, String groupId) {
        this.replaceGroupPermissions(entityAuthorities, groupId, "ROLE_ENTITY_");
    }

    private void replaceGroupPermissions(List<GroupAuthority> entityAuthorities, String groupId, String authorityPrefix) {
        MolgenisGroup molgenisGroup = (MolgenisGroup)this.dataService.findOne("molgenisGroup", (Object)groupId, MolgenisGroup.class);
        if (molgenisGroup == null) {
            throw new RuntimeException("unknown group id [" + groupId + "]");
        }
        for (GroupAuthority entityAuthority : entityAuthorities) {
            entityAuthority.setMolgenisGroup(molgenisGroup);
        }
        Stream oldEntityAuthorities = this.getGroupPermissions(molgenisGroup, authorityPrefix).stream();
        if (oldEntityAuthorities != null) {
            this.dataService.delete("GroupAuthority", oldEntityAuthorities);
        }
        if (!entityAuthorities.isEmpty()) {
            this.dataService.add("GroupAuthority", entityAuthorities.stream());
        }
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional
    public void replaceUserPluginPermissions(List<UserAuthority> pluginAuthorities, String userId) {
        this.replaceUserPermissions(pluginAuthorities, userId, "ROLE_PLUGIN_");
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional
    public void replaceUserEntityClassPermissions(List<UserAuthority> pluginAuthorities, String userId) {
        this.replaceUserPermissions(pluginAuthorities, userId, "ROLE_ENTITY_");
    }

    private void replaceUserPermissions(List<UserAuthority> entityAuthorities, String userId, String authorityType) {
        MolgenisUser molgenisUser = (MolgenisUser)this.dataService.findOne("molgenisUser", (Object)userId, MolgenisUser.class);
        if (molgenisUser == null) {
            throw new RuntimeException("unknown user id [" + userId + "]");
        }
        for (UserAuthority entityAuthority : entityAuthorities) {
            entityAuthority.setMolgenisUser(molgenisUser);
        }
        List<Authority> oldEntityAuthorities = this.getUserPermissions(molgenisUser, authorityType);
        if (oldEntityAuthorities != null && !oldEntityAuthorities.isEmpty()) {
            this.dataService.delete("UserAuthority", oldEntityAuthorities.stream());
        }
        if (!entityAuthorities.isEmpty()) {
            this.dataService.add("UserAuthority", entityAuthorities.stream());
        }
    }

    private List<Authority> getUserPermissions(MolgenisUser molgenisUser, String authorityPrefix) {
        Stream authorities = this.dataService.findAll("UserAuthority", new QueryImpl().eq("molgenisUser", (Object)molgenisUser), UserAuthority.class);
        return authorities.filter(authority -> authorityPrefix != null ? authority.getRole().startsWith(authorityPrefix) : true).collect(Collectors.toList());
    }

    private List<Authority> getGroupPermissions(MolgenisGroup molgenisGroup) {
        return this.getGroupPermissions(Arrays.asList(molgenisGroup));
    }

    private List<Authority> getGroupPermissions(MolgenisGroup molgenisGroup, String authorityPrefix) {
        return this.getGroupPermissions(Arrays.asList(molgenisGroup), authorityPrefix);
    }

    private List<Authority> getGroupPermissions(List<MolgenisGroup> molgenisGroups) {
        return this.getGroupPermissions(molgenisGroups, null);
    }

    private List<Authority> getGroupPermissions(List<MolgenisGroup> molgenisGroups, String authorityPrefix) {
        Stream authorities = this.dataService.findAll("GroupAuthority", new QueryImpl().in("molgenisGroup", molgenisGroups), GroupAuthority.class);
        return authorities.filter(authority -> authorityPrefix != null ? authority.getRole().startsWith(authorityPrefix) : true).collect(Collectors.toList());
    }

    private Permissions createPermissions(List<? extends Authority> entityAuthorities, String authorityPrefix) {
        Permissions permissions = new Permissions();
        if (authorityPrefix.equals("ROLE_PLUGIN_")) {
            List<MolgenisPlugin> plugins = this.getPlugins();
            if (plugins != null) {
                Collections.sort(plugins, new Comparator<MolgenisPlugin>(){

                    @Override
                    public int compare(MolgenisPlugin o1, MolgenisPlugin o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
                for (MolgenisPlugin plugin : plugins) {
                    linkedHashMap.put(plugin.getId(), plugin.getName());
                }
                permissions.setEntityIds(linkedHashMap);
            }
        } else if (authorityPrefix.equals("ROLE_ENTITY_")) {
            List<String> entityClassIds = this.getEntityClassIds();
            if (entityClassIds != null) {
                TreeMap<String, String> treeMap = new TreeMap<String, String>();
                for (String entityClassId : entityClassIds) {
                    treeMap.put(entityClassId, entityClassId);
                }
                permissions.setEntityIds(treeMap);
            }
        } else {
            throw new RuntimeException("Invalid authority prefix [" + authorityPrefix + "]");
        }
        for (Authority authority : entityAuthorities) {
            if (authority.getRole().startsWith(authorityPrefix)) {
                Permission permission = new Permission();
                String authorityType = this.getAuthorityType(authority.getRole(), authorityPrefix);
                String authorityPluginId = this.getAuthorityEntityId(authority.getRole(), authorityPrefix);
                permission.setType(authorityType);
                if (authority instanceof GroupAuthority) {
                    permission.setGroup(((GroupAuthority)authority).getMolgenisGroup().getName());
                    permissions.addGroupPermission(authorityPluginId, permission);
                } else {
                    permissions.addUserPermission(authorityPluginId, permission);
                }
            }
            SimpleGrantedAuthority grantedAuthority = new SimpleGrantedAuthority(authority.getRole());
            Collection hierarchyAuthorities = this.grantedAuthoritiesMapper.mapAuthorities(Collections.singletonList(grantedAuthority));
            hierarchyAuthorities.remove(grantedAuthority);
            for (GrantedAuthority hierarchyAuthority : hierarchyAuthorities) {
                if (!hierarchyAuthority.getAuthority().startsWith(authorityPrefix)) continue;
                String authorityPluginId = this.getAuthorityEntityId(hierarchyAuthority.getAuthority(), authorityPrefix);
                Permission hierarchyPermission = new Permission();
                hierarchyPermission.setType(this.getAuthorityType(hierarchyAuthority.getAuthority(), authorityPrefix));
                permissions.addHierarchyPermission(authorityPluginId, hierarchyPermission);
            }
        }
        permissions.sort();
        return permissions;
    }

    private String getAuthorityEntityId(String role, String authorityPrefix) {
        role = role.substring(authorityPrefix.length());
        return role.substring(role.indexOf(95) + 1).toLowerCase();
    }

    private String getAuthorityType(String role, String authorityPrefix) {
        role = role.substring(authorityPrefix.length());
        return role.substring(0, role.indexOf(95)).toLowerCase();
    }
}

