/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.user;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.molgenis.auth.MolgenisGroup;
import org.molgenis.auth.MolgenisGroupMember;
import org.molgenis.auth.MolgenisUser;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.user.MolgenisUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MolgenisUserServiceImpl
implements MolgenisUserService {
    private final DataService dataService;

    @Autowired
    public MolgenisUserServiceImpl(DataService dataService) {
        if (dataService == null) {
            throw new IllegalArgumentException("DataService is null");
        }
        this.dataService = dataService;
    }

    @Override
    @RunAsSystem
    public List<String> getSuEmailAddresses() {
        Stream superUsers = this.dataService.findAll("molgenisUser", new QueryImpl().eq("superuser", (Object)true), MolgenisUser.class);
        return superUsers.map(MolgenisUser::getEmail).collect(Collectors.toList());
    }

    @Override
    @RunAsSystem
    public MolgenisUser getUser(String username) {
        return (MolgenisUser)this.dataService.findOne("molgenisUser", new QueryImpl().eq("username", (Object)username), MolgenisUser.class);
    }

    @Override
    @RunAsSystem
    public Iterable<MolgenisGroup> getUserGroups(String username) {
        Stream molgenisGroupMembers = this.dataService.findAll("MolgenisGroupMember", new QueryImpl().eq("molgenisUser", (Object)this.getUser(username)), MolgenisGroupMember.class);
        return molgenisGroupMembers.map(MolgenisGroupMember::getMolgenisGroup).collect(Collectors.toList());
    }

    @Override
    @RunAsSystem
    public void update(MolgenisUser user) {
        this.dataService.update("molgenisUser", (Entity)user);
    }

    @Override
    @RunAsSystem
    public MolgenisUser getUserByEmail(String email) {
        return (MolgenisUser)this.dataService.findOne("molgenisUser", new QueryImpl().eq("Email", (Object)email), MolgenisUser.class);
    }
}

