/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security;

import org.molgenis.auth.GroupAuthority;
import org.molgenis.auth.MolgenisGroup;
import org.molgenis.auth.MolgenisUser;
import org.molgenis.auth.UserAuthority;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.security.MolgenisSecurityWebAppDatabasePopulatorService;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.core.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MolgenisSecurityWebAppDatabasePopulatorServiceImpl
implements MolgenisSecurityWebAppDatabasePopulatorService {
    private static final String USERNAME_ADMIN = "admin";
    @Value(value="${admin.password:@null}")
    private String adminPassword;
    @Value(value="${admin.email:molgenis+admin@gmail.com}")
    private String adminEmail;
    @Value(value="${anonymous.email:molgenis+anonymous@gmail.com}")
    private String anonymousEmail;
    private MolgenisUser userAdmin;
    private MolgenisUser anonymousUser;
    private MolgenisGroup allUsersGroup;

    @Override
    @Transactional
    @RunAsSystem
    public void populateDatabase(DataService dataService, String homeControllerId) {
        if (this.adminPassword == null) {
            throw new RuntimeException("please configure the admin.password property in your molgenis-server.properties");
        }
        this.userAdmin = new MolgenisUser();
        this.userAdmin.setUsername(USERNAME_ADMIN);
        this.userAdmin.setPassword(this.adminPassword);
        this.userAdmin.setEmail(this.adminEmail);
        this.userAdmin.setActive(Boolean.valueOf(true));
        this.userAdmin.setSuperuser(Boolean.valueOf(true));
        this.userAdmin.setChangePassword(Boolean.valueOf(false));
        dataService.add("molgenisUser", (Entity)this.userAdmin);
        this.anonymousUser = new MolgenisUser();
        this.anonymousUser.setUsername("anonymous");
        this.anonymousUser.setPassword("anonymous");
        this.anonymousUser.setEmail(this.anonymousEmail);
        this.anonymousUser.setActive(Boolean.valueOf(true));
        this.anonymousUser.setSuperuser(Boolean.valueOf(false));
        this.anonymousUser.setChangePassword(Boolean.valueOf(false));
        dataService.add("molgenisUser", (Entity)this.anonymousUser);
        UserAuthority anonymousAuthority = new UserAuthority();
        anonymousAuthority.setMolgenisUser(this.anonymousUser);
        anonymousAuthority.setRole("ROLE_ANONYMOUS");
        dataService.add("UserAuthority", (Entity)anonymousAuthority);
        this.allUsersGroup = new MolgenisGroup();
        this.allUsersGroup.setName("All Users");
        dataService.add("molgenisGroup", (Entity)this.allUsersGroup);
        dataService.getRepository("molgenisGroup").flush();
        GroupAuthority usersGroupHomeAuthority = new GroupAuthority();
        usersGroupHomeAuthority.setMolgenisGroup(this.allUsersGroup);
        usersGroupHomeAuthority.setRole(SecurityUtils.AUTHORITY_PLUGIN_READ_PREFIX + homeControllerId.toUpperCase());
        dataService.add("GroupAuthority", (Entity)usersGroupHomeAuthority);
        GroupAuthority usersGroupUserAccountAuthority = new GroupAuthority();
        usersGroupUserAccountAuthority.setMolgenisGroup(this.allUsersGroup);
        usersGroupUserAccountAuthority.setRole(SecurityUtils.AUTHORITY_PLUGIN_WRITE_PREFIX + "useraccount".toUpperCase());
        dataService.add("GroupAuthority", (Entity)usersGroupUserAccountAuthority);
        GroupAuthority usersGroupLanguagesAuthority = new GroupAuthority();
        usersGroupLanguagesAuthority.setMolgenisGroup(this.allUsersGroup);
        usersGroupLanguagesAuthority.setRole(SecurityUtils.AUTHORITY_ENTITY_READ_PREFIX + "languages".toUpperCase());
        dataService.add("GroupAuthority", (Entity)usersGroupLanguagesAuthority);
    }

    @Override
    public MolgenisUser getAnonymousUser() {
        return this.anonymousUser;
    }

    @Override
    public MolgenisUser getUserAdmin() {
        return this.userAdmin;
    }

    @Override
    public MolgenisGroup getAllUsersGroup() {
        return this.allUsersGroup;
    }
}

