/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.captcha;

import java.awt.image.BufferedImage;
import javax.servlet.http.HttpSession;
import nl.captcha.Captcha;
import nl.captcha.backgrounds.BackgroundProducer;
import nl.captcha.backgrounds.GradiatedBackgroundProducer;
import org.molgenis.security.captcha.CaptchaException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.stereotype.Service;

@Scope(proxyMode=ScopedProxyMode.TARGET_CLASS, value="session")
@Service
public class CaptchaService {
    @Autowired
    private HttpSession session;

    public BufferedImage createCaptcha(int width, int height) {
        Captcha captcha = new Captcha.Builder(width, height).addText().addBackground((BackgroundProducer)new GradiatedBackgroundProducer()).gimp().addNoise().addBorder().build();
        this.session.setAttribute("simpleCaptcha", (Object)captcha);
        return captcha.getImage();
    }

    public boolean validateCaptcha(String captchaAnswer) throws CaptchaException {
        Captcha captcha = (Captcha)this.session.getAttribute("simpleCaptcha");
        if (captcha == null) {
            throw new CaptchaException("no captcha to validate");
        }
        return captcha.isCorrect(captchaAnswer);
    }

    public void removeCaptcha() {
        this.session.removeAttribute("simpleCaptcha");
    }
}

