/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.token;

import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.molgenis.auth.MolgenisToken;
import org.molgenis.auth.MolgenisUser;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.core.token.TokenService;
import org.molgenis.security.core.token.UnknownTokenException;
import org.molgenis.security.token.TokenGenerator;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.transaction.annotation.Transactional;

public class DataServiceTokenService
implements TokenService {
    private final TokenGenerator tokenGenerator;
    private final DataService dataService;
    private final UserDetailsService userDetailsService;

    public DataServiceTokenService(TokenGenerator tokenGenerator, DataService dataService, UserDetailsService userDetailsService) {
        this.tokenGenerator = tokenGenerator;
        this.dataService = dataService;
        this.userDetailsService = userDetailsService;
    }

    @Transactional(readOnly=true)
    @RunAsSystem
    public UserDetails findUserByToken(String token) throws UnknownTokenException {
        MolgenisToken molgenisToken = this.getMolgenisToken(token);
        return this.userDetailsService.loadUserByUsername(molgenisToken.getMolgenisUser().getUsername());
    }

    @Transactional
    @RunAsSystem
    public String generateAndStoreToken(String username, String description) {
        MolgenisUser user = (MolgenisUser)this.dataService.findOne("molgenisUser", new QueryImpl().eq("username", (Object)username), MolgenisUser.class);
        if (user == null) {
            throw new IllegalArgumentException("Unknown username [" + username + "]");
        }
        String token = this.tokenGenerator.generateToken();
        MolgenisToken molgenisToken = new MolgenisToken();
        molgenisToken.setMolgenisUser(user);
        molgenisToken.setToken(token);
        molgenisToken.setDescription(description);
        molgenisToken.setExpirationDate(DateUtils.addHours((Date)new Date(), (int)2));
        this.dataService.add("MolgenisToken", (Entity)molgenisToken);
        return token;
    }

    @Transactional
    @RunAsSystem
    public void removeToken(String token) throws UnknownTokenException {
        MolgenisToken molgenisToken = this.getMolgenisToken(token);
        this.dataService.delete("MolgenisToken", (Entity)molgenisToken);
    }

    private MolgenisToken getMolgenisToken(String token) throws UnknownTokenException {
        MolgenisToken molgenisToken = (MolgenisToken)this.dataService.findOne("MolgenisToken", new QueryImpl().eq("token", (Object)token), MolgenisToken.class);
        if (molgenisToken == null || molgenisToken.getExpirationDate() != null && new Date().after(molgenisToken.getExpirationDate())) {
            throw new UnknownTokenException("Invalid token");
        }
        return molgenisToken;
    }
}

