/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security;

import com.google.api.client.googleapis.auth.oauth2.GooglePublicKeysManager;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.http.javanet.NetHttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.json.jackson2.JacksonFactory;
import java.util.List;
import javax.servlet.Filter;
import org.molgenis.data.DataService;
import org.molgenis.data.settings.AppSettings;
import org.molgenis.framework.ui.ResourcePathPatterns;
import org.molgenis.security.AjaxAwareLoginUrlAuthenticationEntryPoint;
import org.molgenis.security.MolgenisAnonymousAuthenticationFilter;
import org.molgenis.security.MolgenisChangePasswordFilter;
import org.molgenis.security.core.MolgenisPasswordEncoder;
import org.molgenis.security.core.MolgenisPermissionService;
import org.molgenis.security.core.token.TokenService;
import org.molgenis.security.google.GoogleAuthenticationProcessingFilter;
import org.molgenis.security.permission.MolgenisPermissionServiceImpl;
import org.molgenis.security.session.ApiSessionExpirationFilter;
import org.molgenis.security.token.DataServiceTokenService;
import org.molgenis.security.token.TokenAuthenticationFilter;
import org.molgenis.security.token.TokenAuthenticationProvider;
import org.molgenis.security.token.TokenGenerator;
import org.molgenis.security.user.MolgenisUserDetailsChecker;
import org.molgenis.security.user.MolgenisUserDetailsService;
import org.molgenis.security.user.MolgenisUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.access.hierarchicalroles.RoleHierarchyAuthoritiesMapper;
import org.springframework.security.access.intercept.RunAsImplAuthenticationProvider;
import org.springframework.security.access.vote.RoleHierarchyVoter;
import org.springframework.security.access.vote.RoleVoter;
import org.springframework.security.authentication.AnonymousAuthenticationProvider;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.dao.DaoAuthenticationProvider;
import org.springframework.security.config.annotation.authentication.builders.AuthenticationManagerBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.security.core.userdetails.UserDetailsChecker;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.crypto.bcrypt.BCryptPasswordEncoder;
import org.springframework.security.crypto.password.PasswordEncoder;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.AnonymousAuthenticationFilter;
import org.springframework.security.web.authentication.LoginUrlAuthenticationEntryPoint;
import org.springframework.security.web.authentication.logout.SimpleUrlLogoutSuccessHandler;
import org.springframework.security.web.authentication.switchuser.SwitchUserFilter;
import org.springframework.security.web.header.HeaderWriter;
import org.springframework.security.web.header.writers.CacheControlHeadersWriter;
import org.springframework.security.web.header.writers.DelegatingRequestMatcherHeaderWriter;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.OrRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public abstract class MolgenisWebAppSecurityConfig
extends WebSecurityConfigurerAdapter {
    private static final String ANONYMOUS_AUTHENTICATION_KEY = "anonymousAuthenticationKey";
    @Autowired
    private DataService dataService;
    @Autowired
    private MolgenisUserService molgenisUserService;
    @Autowired
    private AppSettings appSettings;

    protected void configure(HttpSecurity http) throws Exception {
        NegatedRequestMatcher matcher = new NegatedRequestMatcher((RequestMatcher)new OrRequestMatcher(new RequestMatcher[]{new AntPathRequestMatcher(ResourcePathPatterns.PATTERN_CSS), new AntPathRequestMatcher(ResourcePathPatterns.PATTERN_JS), new AntPathRequestMatcher(ResourcePathPatterns.PATTERN_IMG), new AntPathRequestMatcher(ResourcePathPatterns.PATTERN_FONTS)}));
        DelegatingRequestMatcherHeaderWriter cacheControlHeaderWriter = new DelegatingRequestMatcherHeaderWriter((RequestMatcher)matcher, (HeaderWriter)new CacheControlHeadersWriter());
        http.headers().contentTypeOptions().and().xssProtection().and().httpStrictTransportSecurity().and().frameOptions().and().addHeaderWriter((HeaderWriter)cacheControlHeaderWriter);
        http.addFilterBefore((Filter)this.anonymousAuthFilter(), AnonymousAuthenticationFilter.class);
        http.authenticationProvider((AuthenticationProvider)this.anonymousAuthenticationProvider());
        http.addFilterBefore((Filter)this.apiSessionExpirationFilter(), MolgenisAnonymousAuthenticationFilter.class);
        http.authenticationProvider(this.tokenAuthenticationProvider());
        http.authenticationProvider(this.runAsAuthenticationProvider());
        http.addFilterBefore(this.tokenAuthenticationFilter(), ApiSessionExpirationFilter.class);
        http.addFilterBefore(this.googleAuthenticationProcessingFilter(), TokenAuthenticationFilter.class);
        http.addFilterAfter(this.changePasswordFilter(), SwitchUserFilter.class);
        ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry expressionInterceptUrlRegistry = http.authorizeRequests();
        this.configureUrlAuthorization(expressionInterceptUrlRegistry);
        ((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((HttpSecurity)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)expressionInterceptUrlRegistry.antMatchers(new String[]{"/login"})).permitAll().antMatchers(new String[]{"/login/google"})).permitAll().antMatchers(new String[]{"/logo/**"})).permitAll().antMatchers(new String[]{"/molgenis.R"})).permitAll().antMatchers(new String[]{"/account/password/change"})).authenticated().antMatchers(new String[]{"/account/**"})).permitAll().antMatchers(new String[]{ResourcePathPatterns.PATTERN_CSS})).permitAll().antMatchers(new String[]{ResourcePathPatterns.PATTERN_IMG})).permitAll().antMatchers(new String[]{ResourcePathPatterns.PATTERN_JS})).permitAll().antMatchers(new String[]{ResourcePathPatterns.PATTERN_FONTS})).permitAll().antMatchers(new String[]{"/html/**"})).permitAll().antMatchers(new String[]{"/plugin/void/**"})).permitAll().antMatchers(new String[]{"/api/**"})).permitAll().antMatchers(new String[]{"/search"})).permitAll().antMatchers(new String[]{"/captcha"})).permitAll().antMatchers(new String[]{"/dataindexerstatus"})).authenticated().antMatchers(new String[]{"/permission/**/read/**"})).permitAll().antMatchers(new String[]{"/permission/**/write/**"})).permitAll().antMatchers(new String[]{"/scripts/**/run"})).authenticated().antMatchers(new String[]{"/files/**"})).permitAll().anyRequest()).denyAll().and()).httpBasic().authenticationEntryPoint((AuthenticationEntryPoint)this.authenticationEntryPoint()).and()).formLogin().loginPage("/login").failureUrl("/login?error")).and()).logout().deleteCookies(new String[]{"JSESSIONID"}).addLogoutHandler((req, res, auth) -> {
            if (req.getSession(false) != null && req.getSession().getAttribute("continueWithUnsupportedBrowser") != null) {
                req.setAttribute("continueWithUnsupportedBrowser", (Object)true);
            }
        }).logoutSuccessHandler((req, res, auth) -> {
            StringBuilder logoutSuccessUrl = new StringBuilder("/");
            if (req.getAttribute("continueWithUnsupportedBrowser") != null) {
                logoutSuccessUrl.append("?continueWithUnsupportedBrowser=true");
            }
            SimpleUrlLogoutSuccessHandler logoutSuccessHandler = new SimpleUrlLogoutSuccessHandler();
            logoutSuccessHandler.setDefaultTargetUrl(logoutSuccessUrl.toString());
            logoutSuccessHandler.onLogoutSuccess(req, res, auth);
        }).and()).csrf().disable();
    }

    @Bean
    public AuthenticationProvider runAsAuthenticationProvider() {
        RunAsImplAuthenticationProvider provider = new RunAsImplAuthenticationProvider();
        provider.setKey("Job Execution");
        return provider;
    }

    protected abstract void configureUrlAuthorization(ExpressionUrlAuthorizationConfigurer.ExpressionInterceptUrlRegistry var1);

    protected abstract RoleHierarchy roleHierarchy();

    @Bean
    public MolgenisAnonymousAuthenticationFilter anonymousAuthFilter() {
        return new MolgenisAnonymousAuthenticationFilter(ANONYMOUS_AUTHENTICATION_KEY, "anonymous", this.userDetailsService());
    }

    protected abstract List<GrantedAuthority> createAnonymousUserAuthorities();

    @Bean
    public AnonymousAuthenticationProvider anonymousAuthenticationProvider() {
        return new AnonymousAuthenticationProvider(ANONYMOUS_AUTHENTICATION_KEY);
    }

    @Bean
    public TokenService tokenService() {
        return new DataServiceTokenService(new TokenGenerator(), this.dataService, this.userDetailsService());
    }

    @Bean
    public AuthenticationProvider tokenAuthenticationProvider() {
        return new TokenAuthenticationProvider(this.tokenService());
    }

    @Bean
    public Filter tokenAuthenticationFilter() {
        return new TokenAuthenticationFilter(this.tokenAuthenticationProvider());
    }

    @Bean
    public GooglePublicKeysManager googlePublicKeysManager() {
        NetHttpTransport transport = new NetHttpTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        return new GooglePublicKeysManager((HttpTransport)transport, (JsonFactory)jsonFactory);
    }

    @Bean
    public Filter googleAuthenticationProcessingFilter() throws Exception {
        GoogleAuthenticationProcessingFilter googleAuthenticationProcessingFilter = new GoogleAuthenticationProcessingFilter(this.googlePublicKeysManager(), this.dataService, (MolgenisUserDetailsService)this.userDetailsService(), this.appSettings);
        googleAuthenticationProcessingFilter.setAuthenticationManager(this.authenticationManagerBean());
        return googleAuthenticationProcessingFilter;
    }

    @Bean
    public Filter changePasswordFilter() {
        return new MolgenisChangePasswordFilter(this.molgenisUserService, this.redirectStrategy());
    }

    @Bean
    public RedirectStrategy redirectStrategy() {
        return new DefaultRedirectStrategy();
    }

    @Bean
    public RoleHierarchy roleHierarchyBean() {
        return this.roleHierarchy();
    }

    @Bean
    public RoleVoter roleVoter() {
        return new RoleHierarchyVoter(this.roleHierarchy());
    }

    @Bean
    public GrantedAuthoritiesMapper roleHierarchyAuthoritiesMapper() {
        return new RoleHierarchyAuthoritiesMapper(this.roleHierarchy());
    }

    @Bean
    public PasswordEncoder passwordEncoder() {
        return new MolgenisPasswordEncoder(new BCryptPasswordEncoder());
    }

    protected UserDetailsService userDetailsService() {
        return new MolgenisUserDetailsService(this.dataService, this.roleHierarchyAuthoritiesMapper());
    }

    @Bean
    public UserDetailsService userDetailsServiceBean() throws Exception {
        return this.userDetailsService();
    }

    @Bean
    public UserDetailsChecker userDetailsChecker() {
        return new MolgenisUserDetailsChecker();
    }

    protected void configure(AuthenticationManagerBuilder auth) {
        try {
            auth.userDetailsService(this.userDetailsServiceBean());
            DaoAuthenticationProvider daoAuthenticationProvider = new DaoAuthenticationProvider();
            daoAuthenticationProvider.setPasswordEncoder((Object)this.passwordEncoder());
            daoAuthenticationProvider.setUserDetailsService(this.userDetailsServiceBean());
            daoAuthenticationProvider.setPreAuthenticationChecks(this.userDetailsChecker());
            auth.authenticationProvider((AuthenticationProvider)daoAuthenticationProvider);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Bean
    public AuthenticationManager authenticationManagerBean() throws Exception {
        return super.authenticationManagerBean();
    }

    @Bean
    public MolgenisPermissionService molgenisPermissionService() {
        return new MolgenisPermissionServiceImpl();
    }

    @Bean
    public LoginUrlAuthenticationEntryPoint authenticationEntryPoint() {
        return new AjaxAwareLoginUrlAuthenticationEntryPoint("/login");
    }

    @Bean
    public ApiSessionExpirationFilter apiSessionExpirationFilter() {
        return new ApiSessionExpirationFilter();
    }
}

