/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.permission;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.molgenis.auth.MolgenisUser;
import org.molgenis.auth.UserAuthority;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.core.utils.SecurityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.stereotype.Component;

@Component
public class PermissionSystemService {
    private final DataService dataService;

    @Autowired
    public PermissionSystemService(DataService dataService) {
        this.dataService = dataService;
    }

    @RunAsSystem
    public void giveUserEntityPermissions(SecurityContext securityContext, List<String> entities) {
        MolgenisUser user;
        Authentication auth = securityContext.getAuthentication();
        if (!auth.getAuthorities().contains(new SimpleGrantedAuthority("ROLE_ADMIN")) && !auth.getAuthorities().contains(new SimpleGrantedAuthority("ROLE_SYSTEM")) && (user = (MolgenisUser)this.dataService.findOne("molgenisUser", new QueryImpl().eq("username", (Object)SecurityUtils.getUsername((Authentication)auth)), MolgenisUser.class)) != null) {
            ArrayList roles = Lists.newArrayList((Iterable)auth.getAuthorities());
            for (String entity : entities) {
                for (Permission permission : Permission.values()) {
                    if (permission == Permission.NONE) continue;
                    String role = "ROLE_ENTITY_" + permission.toString() + "_" + entity.toUpperCase();
                    roles.add(new SimpleGrantedAuthority(role));
                    UserAuthority userAuthority = new UserAuthority();
                    userAuthority.setMolgenisUser(user);
                    userAuthority.setRole(role);
                    if (permission != Permission.WRITEMETA) continue;
                    this.dataService.add("UserAuthority", (Entity)userAuthority);
                }
            }
            auth = new UsernamePasswordAuthenticationToken(auth.getPrincipal(), null, (Collection)roles);
            securityContext.setAuthentication(auth);
        }
    }
}

