/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.owned;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Fetch;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.aggregation.AggregateQuery;
import org.molgenis.data.aggregation.AggregateResult;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.util.EntityUtils;

public class OwnedEntityRepositoryDecorator
extends AbstractRepositoryDecorator<Entity> {
    private final Repository<Entity> decoratedRepo;

    public OwnedEntityRepositoryDecorator(Repository<Entity> decoratedRepo) {
        this.decoratedRepo = Objects.requireNonNull(decoratedRepo);
    }

    protected Repository<Entity> delegate() {
        return this.decoratedRepo;
    }

    public Query<Entity> query() {
        return new QueryImpl((Repository)this);
    }

    public Iterator<Entity> iterator() {
        if (this.mustAddRowLevelSecurity()) {
            return this.findAll((Query<Entity>)new QueryImpl()).iterator();
        }
        return this.decoratedRepo.iterator();
    }

    public void forEachBatched(Fetch fetch, Consumer<List<Entity>> consumer, int batchSize) {
        if (fetch != null) {
            fetch.field("ownerUsername");
        }
        this.decoratedRepo.forEachBatched(fetch, entities -> {
            if (this.mustAddRowLevelSecurity()) {
                consumer.accept(entities.stream().filter(OwnedEntityRepositoryDecorator::currentUserIsOwner).collect(Collectors.toList()));
            } else {
                consumer.accept((List<Entity>)entities);
            }
        }, batchSize);
    }

    public long count() {
        if (this.mustAddRowLevelSecurity()) {
            return this.count((Query<Entity>)new QueryImpl());
        }
        return this.decoratedRepo.count();
    }

    public long count(Query<Entity> q) {
        if (this.mustAddRowLevelSecurity()) {
            OwnedEntityRepositoryDecorator.addRowLevelSecurity(q);
        }
        return this.decoratedRepo.count(q);
    }

    public Stream<Entity> findAll(Query<Entity> q) {
        if (this.mustAddRowLevelSecurity()) {
            OwnedEntityRepositoryDecorator.addRowLevelSecurity(q);
        }
        return this.decoratedRepo.findAll(q);
    }

    public Entity findOne(Query<Entity> q) {
        if (this.mustAddRowLevelSecurity()) {
            OwnedEntityRepositoryDecorator.addRowLevelSecurity(q);
        }
        return this.decoratedRepo.findOne(q);
    }

    public Entity findOneById(Object id) {
        Entity e = this.decoratedRepo.findOneById(id);
        if (this.mustAddRowLevelSecurity() && !OwnedEntityRepositoryDecorator.currentUserIsOwner(e)) {
            return null;
        }
        return e;
    }

    public Entity findOneById(Object id, Fetch fetch) {
        if (fetch != null) {
            fetch.field("ownerUsername");
        }
        Entity e = this.decoratedRepo.findOneById(id, fetch);
        if (this.mustAddRowLevelSecurity() && !OwnedEntityRepositoryDecorator.currentUserIsOwner(e)) {
            return null;
        }
        return e;
    }

    public Stream<Entity> findAll(Stream<Object> ids) {
        Stream<Entity> entities = this.decoratedRepo.findAll(ids);
        if (this.mustAddRowLevelSecurity()) {
            entities = entities.filter(OwnedEntityRepositoryDecorator::currentUserIsOwner);
        }
        return entities;
    }

    public Stream<Entity> findAll(Stream<Object> ids, Fetch fetch) {
        if (fetch != null) {
            fetch.field("ownerUsername");
        }
        Stream<Entity> entities = this.decoratedRepo.findAll(ids, fetch);
        if (this.mustAddRowLevelSecurity()) {
            entities = entities.filter(OwnedEntityRepositoryDecorator::currentUserIsOwner);
        }
        return entities;
    }

    public AggregateResult aggregate(AggregateQuery aggregateQuery) {
        if (this.mustAddRowLevelSecurity()) {
            OwnedEntityRepositoryDecorator.addRowLevelSecurity((Query<Entity>)aggregateQuery.getQuery());
        }
        return this.decoratedRepo.aggregate(aggregateQuery);
    }

    public void update(Entity entity) {
        if (this.isOwnedEntityType() && (this.mustAddRowLevelSecurity() || entity.get("ownerUsername") == null)) {
            entity.set("ownerUsername", (Object)SecurityUtils.getCurrentUsername());
        }
        this.decoratedRepo.update(entity);
    }

    public void update(Stream<Entity> entities) {
        if (this.isOwnedEntityType()) {
            boolean mustAddRowLevelSecurity = this.mustAddRowLevelSecurity();
            String currentUsername = SecurityUtils.getCurrentUsername();
            entities = entities.map(entity -> {
                if (mustAddRowLevelSecurity || entity.get("ownerUsername") == null) {
                    entity.set("ownerUsername", (Object)currentUsername);
                }
                return entity;
            });
        }
        this.decoratedRepo.update(entities);
    }

    public void delete(Entity entity) {
        if (this.mustAddRowLevelSecurity() && !OwnedEntityRepositoryDecorator.currentUserIsOwner(entity)) {
            return;
        }
        this.decoratedRepo.delete(entity);
    }

    public void delete(Stream<Entity> entities) {
        if (this.mustAddRowLevelSecurity()) {
            entities = entities.filter(OwnedEntityRepositoryDecorator::currentUserIsOwner);
        }
        this.decoratedRepo.delete(entities);
    }

    public void deleteById(Object id) {
        Entity entity;
        if (this.mustAddRowLevelSecurity() && (entity = this.findOneById(id)) != null && !OwnedEntityRepositoryDecorator.currentUserIsOwner(entity)) {
            return;
        }
        this.decoratedRepo.deleteById(id);
    }

    public void deleteAll(Stream<Object> ids) {
        if (this.mustAddRowLevelSecurity()) {
            this.delete(this.decoratedRepo.findAll(ids));
        } else {
            this.decoratedRepo.deleteAll(ids);
        }
    }

    public void deleteAll() {
        if (this.mustAddRowLevelSecurity()) {
            this.decoratedRepo.forEachBatched(entities -> this.delete(entities.stream()), 1000);
        } else {
            this.decoratedRepo.deleteAll();
        }
    }

    public void add(Entity entity) {
        if (this.isOwnedEntityType() && (this.mustAddRowLevelSecurity() || entity.get("ownerUsername") == null)) {
            entity.set("ownerUsername", (Object)SecurityUtils.getCurrentUsername());
        }
        this.decoratedRepo.add(entity);
    }

    public Integer add(Stream<Entity> entities) {
        if (this.isOwnedEntityType()) {
            boolean mustAddRowLevelSecurity = this.mustAddRowLevelSecurity();
            String currentUsername = SecurityUtils.getCurrentUsername();
            entities = entities.map(entity -> {
                if (mustAddRowLevelSecurity || entity.get("ownerUsername") == null) {
                    entity.set("ownerUsername", (Object)currentUsername);
                }
                return entity;
            });
        }
        return this.decoratedRepo.add(entities);
    }

    private boolean mustAddRowLevelSecurity() {
        return !SecurityUtils.currentUserIsSu() && !SecurityUtils.currentUserHasRole((String[])new String[]{"ROLE_SYSTEM"}) && this.isOwnedEntityType();
    }

    private boolean isOwnedEntityType() {
        return EntityUtils.doesExtend((EntityType)this.getEntityType(), (String)"sys_sec_Owned");
    }

    private static void addRowLevelSecurity(Query<Entity> q) {
        String user = SecurityUtils.getCurrentUsername();
        if (user != null) {
            if (!q.getRules().isEmpty()) {
                q.and();
            }
            q.eq("ownerUsername", (Object)user);
        }
    }

    private static String getOwnerUserName(Entity questionnaire) {
        return questionnaire.getString("ownerUsername");
    }

    private static boolean currentUserIsOwner(Entity entity) {
        return null != entity && Objects.equals(SecurityUtils.getCurrentUsername(), OwnedEntityRepositoryDecorator.getOwnerUserName(entity));
    }
}

