/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.permission;

import java.util.Collection;
import org.molgenis.security.core.MolgenisPermissionService;
import org.molgenis.security.core.Permission;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;

public class MolgenisPermissionServiceImpl
implements MolgenisPermissionService {
    public boolean hasPermissionOnPlugin(String pluginId, Permission permission) {
        return this.hasPermission(pluginId, permission, "ROLE_PLUGIN_");
    }

    public boolean hasPermissionOnEntity(String entityName, Permission permission) {
        return this.hasPermission(entityName, permission, "ROLE_ENTITY_");
    }

    private boolean hasPermission(String authorityId, Permission permission, String authorityPrefix) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return false;
        }
        String pluginAuthority = authorityPrefix + permission.toString() + '_' + authorityId;
        Collection grantedAuthorities = authentication.getAuthorities();
        if (grantedAuthorities != null) {
            for (GrantedAuthority grantedAuthority : grantedAuthorities) {
                String authority = grantedAuthority.getAuthority();
                if (!authority.equals("ROLE_SU") && !authority.equals("ROLE_SYSTEM") && !authority.equals(pluginAuthority)) continue;
                return true;
            }
        }
        return false;
    }
}

