/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.session;

import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.molgenis.security.core.utils.SecurityUtils;
import org.springframework.web.filter.GenericFilterBean;

public class ApiSessionExpirationFilter
extends GenericFilterBean {
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (!SecurityUtils.currentUserIsAuthenticated() && httpRequest.getRequestURI().startsWith("/api/") && SecurityUtils.isSessionExpired((HttpServletRequest)httpRequest) && !httpRequest.getRequestURI().startsWith("/api/v1/login") && !httpRequest.getRequestURI().startsWith("/api/v1/logout") && !httpRequest.getRequestURI().startsWith("/api/v2/version")) {
            httpRequest.getSession().setAttribute("sessionExpired", (Object)true);
        }
        chain.doFilter(request, response);
    }
}

