/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.account;

import java.net.URI;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.auth.Group;
import org.molgenis.auth.GroupMember;
import org.molgenis.auth.GroupMemberFactory;
import org.molgenis.auth.User;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.populate.IdGenerator;
import org.molgenis.data.settings.AppSettings;
import org.molgenis.security.account.AccountService;
import org.molgenis.security.account.EmailAlreadyExistsException;
import org.molgenis.security.account.UsernameAlreadyExistsException;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.user.MolgenisUserException;
import org.molgenis.security.user.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailException;
import org.springframework.mail.MailSender;
import org.springframework.mail.SimpleMailMessage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AccountServiceImpl
implements AccountService {
    private static final Logger LOG = LoggerFactory.getLogger(AccountServiceImpl.class);
    private final DataService dataService;
    private final MailSender mailSender;
    private final UserService userService;
    private final AppSettings appSettings;
    private final GroupMemberFactory groupMemberFactory;
    private final IdGenerator idGenerator;

    @Autowired
    public AccountServiceImpl(DataService dataService, MailSender mailSender, UserService userService, AppSettings appSettings, GroupMemberFactory groupMemberFactory, IdGenerator idGenerator) {
        this.dataService = Objects.requireNonNull(dataService);
        this.mailSender = Objects.requireNonNull(mailSender);
        this.userService = Objects.requireNonNull(userService);
        this.appSettings = Objects.requireNonNull(appSettings);
        this.groupMemberFactory = Objects.requireNonNull(groupMemberFactory);
        this.idGenerator = Objects.requireNonNull(idGenerator);
    }

    @Override
    @RunAsSystem
    @Transactional
    public void createUser(User user, String baseActivationUri) throws UsernameAlreadyExistsException, EmailAlreadyExistsException {
        List<String> activationEmailAddresses;
        if (this.userService.getUser(user.getUsername()) != null) {
            throw new UsernameAlreadyExistsException("Username '" + user.getUsername() + "' already exists.");
        }
        if (this.userService.getUserByEmail(user.getEmail()) != null) {
            throw new EmailAlreadyExistsException("Email '" + user.getEmail() + "' is already registered.");
        }
        String activationCode = this.idGenerator.generateId(IdGenerator.Strategy.SECURE_RANDOM);
        if (this.appSettings.getSignUpModeration()) {
            activationEmailAddresses = this.userService.getSuEmailAddresses();
            if (activationEmailAddresses == null || activationEmailAddresses.isEmpty()) {
                throw new MolgenisDataException("Administrator account is missing required email address");
            }
        } else {
            String activationEmailAddress = user.getEmail();
            if (activationEmailAddress == null || activationEmailAddress.isEmpty()) {
                throw new MolgenisDataException("User '" + user.getUsername() + "' is missing required email address");
            }
            activationEmailAddresses = Arrays.asList(activationEmailAddress);
        }
        user.setActivationCode(activationCode);
        user.setActive(Boolean.valueOf(false));
        this.dataService.add("sys_sec_User", (Entity)user);
        LOG.debug("created user " + user.getUsername());
        Group group = (Group)this.dataService.query("sys_sec_Group", Group.class).eq("name", (Object)"All Users").findOne();
        GroupMember groupMember = null;
        if (group != null) {
            groupMember = (GroupMember)this.groupMemberFactory.create();
            groupMember.setGroup(group);
            groupMember.setUser(user);
            this.dataService.add("sys_sec_GroupMember", (Entity)groupMember);
        }
        URI activationUri = URI.create(baseActivationUri + '/' + activationCode);
        try {
            SimpleMailMessage mailMessage = new SimpleMailMessage();
            mailMessage.setTo(activationEmailAddresses.toArray(new String[0]));
            mailMessage.setSubject("User registration for " + this.appSettings.getTitle());
            mailMessage.setText(this.createActivationEmailText(user, activationUri));
            this.mailSender.send(mailMessage);
        }
        catch (MailException mce) {
            LOG.error("Could not send signup mail", (Throwable)mce);
            if (groupMember != null) {
                this.dataService.delete("sys_sec_GroupMember", (Entity)groupMember);
            }
            this.dataService.delete("sys_sec_User", (Entity)user);
            throw new MolgenisUserException("An error occurred. Please contact the administrator. You are not signed up!");
        }
        LOG.debug("send activation email for user " + user.getUsername() + " to " + StringUtils.join(activationEmailAddresses, (char)','));
    }

    @Override
    @RunAsSystem
    public void activateUser(String activationCode) {
        User user = (User)this.dataService.query("sys_sec_User", User.class).eq("active", (Object)false).and().eq("activationCode", (Object)activationCode).findOne();
        if (user == null) {
            throw new MolgenisUserException("Invalid activation code or account already activated.");
        }
        user.setActive(Boolean.valueOf(true));
        this.dataService.update("sys_sec_User", (Entity)user);
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setTo(user.getEmail());
        mailMessage.setSubject("Your registration request for " + this.appSettings.getTitle());
        mailMessage.setText(this.createActivatedEmailText(user, this.appSettings.getTitle()));
        this.mailSender.send(mailMessage);
    }

    @Override
    @RunAsSystem
    public void changePassword(String username, String newPassword) {
        User user = (User)this.dataService.query("sys_sec_User", User.class).eq("username", (Object)username).findOne();
        if (user == null) {
            throw new MolgenisUserException(String.format("Unknown user [%s]", username));
        }
        user.setPassword(newPassword);
        user.setChangePassword(Boolean.valueOf(false));
        this.dataService.update("sys_sec_User", (Entity)user);
        LOG.info("Changed password of user [{}]", (Object)username);
    }

    @Override
    @RunAsSystem
    public void resetPassword(String userEmail) {
        User user = (User)this.dataService.query("sys_sec_User", User.class).eq("Email", (Object)userEmail).findOne();
        if (user == null) {
            throw new MolgenisUserException("Invalid email address.");
        }
        String newPassword = this.idGenerator.generateId(IdGenerator.Strategy.SHORT_SECURE_RANDOM);
        user.setPassword(newPassword);
        user.setChangePassword(Boolean.valueOf(true));
        this.dataService.update("sys_sec_User", (Entity)user);
        SimpleMailMessage mailMessage = new SimpleMailMessage();
        mailMessage.setTo(user.getEmail());
        mailMessage.setSubject("Your new password request");
        mailMessage.setText(this.createPasswordResettedEmailText(newPassword));
        this.mailSender.send(mailMessage);
    }

    private String createActivationEmailText(User user, URI activationUri) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("User registration for ").append(this.appSettings.getTitle()).append('\n');
        strBuilder.append("User name: ").append(user.getUsername()).append(" Full name: ").append(user.getFirstName());
        strBuilder.append(' ').append(user.getLastName()).append('\n');
        strBuilder.append("In order to activate the user visit the following URL:").append('\n');
        strBuilder.append(activationUri).append('\n').append('\n');
        return strBuilder.toString();
    }

    private String createActivatedEmailText(User user, String appName) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("Dear ").append(user.getFirstName()).append(" ").append(user.getLastName()).append(",\n\n");
        strBuilder.append("your registration request for ").append(appName).append(" was approved.\n");
        strBuilder.append("Your account is now active.\n");
        return strBuilder.toString();
    }

    private String createPasswordResettedEmailText(String newPassword) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append("Somebody, probably you, requested a new password for ").append(this.appSettings.getTitle()).append(".\n");
        strBuilder.append("The new password is: ").append(newPassword).append('\n');
        strBuilder.append("Note: we strongly recommend you reset your password after log-in!");
        return strBuilder.toString();
    }
}

