/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.user;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.molgenis.auth.Group;
import org.molgenis.auth.GroupMember;
import org.molgenis.auth.User;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Fetch;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.user.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UserServiceImpl
implements UserService {
    private final DataService dataService;

    @Autowired
    public UserServiceImpl(DataService dataService) {
        if (dataService == null) {
            throw new IllegalArgumentException("DataService is null");
        }
        this.dataService = dataService;
    }

    @Override
    @RunAsSystem
    public List<String> getSuEmailAddresses() {
        Stream superUsers = this.dataService.findAll("sys_sec_User", new QueryImpl().eq("superuser", (Object)true), User.class);
        return superUsers.map(User::getEmail).collect(Collectors.toList());
    }

    @Override
    @RunAsSystem
    public User getUser(String username) {
        return (User)this.dataService.findOne("sys_sec_User", new QueryImpl().eq("username", (Object)username), User.class);
    }

    @Override
    @RunAsSystem
    public Iterable<Group> getUserGroups(String username) {
        Fetch fetch = new Fetch().field("Group", new Fetch().field("id").field("name").field("active"));
        Stream molgenisGroupMembers = this.dataService.query("sys_sec_GroupMember", GroupMember.class).fetch(fetch).eq("User", (Object)this.getUser(username)).findAll();
        return molgenisGroupMembers.map(GroupMember::getGroup).collect(Collectors.toList());
    }

    @Override
    @RunAsSystem
    public void update(User user) {
        this.dataService.update("sys_sec_User", (Entity)user);
    }

    @Override
    @RunAsSystem
    public User getUserByEmail(String email) {
        return (User)this.dataService.findOne("sys_sec_User", new QueryImpl().eq("Email", (Object)email), User.class);
    }
}

