/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.permission;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.molgenis.auth.User;
import org.molgenis.auth.UserAuthority;
import org.molgenis.auth.UserAuthorityFactory;
import org.molgenis.data.DataService;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.runas.RunAsSystemProxy;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.security.permission.PermissionSystemService;
import org.molgenis.security.user.UserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.hierarchicalroles.RoleHierarchy;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class PermissionSystemServiceImpl
implements PermissionSystemService {
    private final UserService userService;
    private final UserAuthorityFactory userAuthorityFactory;
    private final RoleHierarchy roleHierarchy;
    private final DataService dataService;

    @Autowired
    public PermissionSystemServiceImpl(UserService userService, UserAuthorityFactory userAuthorityFactory, RoleHierarchy roleHierarchy, DataService dataService) {
        this.userService = Objects.requireNonNull(userService);
        this.userAuthorityFactory = Objects.requireNonNull(userAuthorityFactory);
        this.roleHierarchy = Objects.requireNonNull(roleHierarchy);
        this.dataService = Objects.requireNonNull(dataService);
    }

    public void giveUserWriteMetaPermissions(EntityType entityType) {
        this.giveUserWriteMetaPermissions(Collections.singleton(entityType));
    }

    public void giveUserWriteMetaPermissions(Collection<EntityType> entityTypes) {
        if (SecurityUtils.currentUserIsSuOrSystem()) {
            return;
        }
        SecurityContext securityContext = SecurityContextHolder.getContext();
        RunAsSystemProxy.runAsSystem(() -> this.giveUserEntityPermissionsAsSystem(securityContext, entityTypes));
    }

    private void giveUserEntityPermissionsAsSystem(SecurityContext securityContext, Collection<EntityType> entityTypes) {
        Collection<GrantedAuthority> grantedAuthorities = this.getGrantedAuthorities(entityTypes);
        this.updateUserAuthorities(securityContext, grantedAuthorities);
        this.updateSecurityContext(securityContext, grantedAuthorities);
    }

    private Collection<GrantedAuthority> getGrantedAuthorities(Collection<EntityType> entityTypeStream) {
        return entityTypeStream.stream().map(this::toGrantedAuthority).collect(Collectors.toList());
    }

    private GrantedAuthority toGrantedAuthority(EntityType entityType) {
        String role = "ROLE_ENTITY_" + Permission.WRITEMETA.toString() + '_' + entityType.getId();
        return new SimpleGrantedAuthority(role);
    }

    private void updateUserAuthorities(SecurityContext context, Collection<GrantedAuthority> grantedAuthorities) {
        User user = this.userService.getUser(SecurityUtils.getUsername((Authentication)context.getAuthentication()));
        Stream<UserAuthority> userAuthorityStream = grantedAuthorities.stream().map(grantedAuthority -> {
            UserAuthority userAuthority = (UserAuthority)this.userAuthorityFactory.create();
            userAuthority.setUser(user);
            userAuthority.setRole(grantedAuthority.getAuthority());
            return userAuthority;
        });
        this.dataService.add("sys_sec_UserAuthority", userAuthorityStream);
    }

    private void updateSecurityContext(SecurityContext context, Collection<? extends GrantedAuthority> authorities) {
        Collection reachableAuthorities = this.roleHierarchy.getReachableGrantedAuthorities(authorities);
        ArrayList newGrantedAuthorities = Lists.newArrayList((Iterable)context.getAuthentication().getAuthorities());
        newGrantedAuthorities.addAll(reachableAuthorities);
        Authentication authentication = context.getAuthentication();
        Object principal = authentication.getPrincipal();
        Object credentials = authentication.getCredentials();
        context.setAuthentication((Authentication)new UsernamePasswordAuthenticationToken(principal, credentials, (Collection)newGrantedAuthorities));
    }
}

