/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.permission;

import java.util.Objects;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.PermissionService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/permission"})
public class MolgenisPermissionController {
    private final PermissionService permissionService;

    @Autowired
    public MolgenisPermissionController(PermissionService permissionService) {
        this.permissionService = Objects.requireNonNull(permissionService);
    }

    @RequestMapping(value={"/{entityTypeId}/read"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean hasReadPermission(@PathVariable(value="entityTypeId") String entityTypeId) {
        return this.permissionService.hasPermissionOnEntityType(entityTypeId, Permission.READ);
    }

    @RequestMapping(value={"/{entityTypeId}/write"}, method={RequestMethod.GET})
    @ResponseBody
    public boolean hasWritePermission(@PathVariable(value="entityTypeId") String entityTypeId) {
        return this.permissionService.hasPermissionOnEntityType(entityTypeId, Permission.WRITE);
    }
}

