/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.permission;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.molgenis.auth.Authority;
import org.molgenis.auth.Group;
import org.molgenis.auth.GroupAuthority;
import org.molgenis.auth.GroupMember;
import org.molgenis.auth.User;
import org.molgenis.auth.UserAuthority;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Fetch;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.plugin.model.Plugin;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.security.permission.Permission;
import org.molgenis.security.permission.PermissionManagerService;
import org.molgenis.security.permission.Permissions;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.authority.mapping.GrantedAuthoritiesMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PermissionManagerServiceImpl
implements PermissionManagerService {
    private final DataService dataService;
    private final GrantedAuthoritiesMapper grantedAuthoritiesMapper;

    @Autowired
    public PermissionManagerServiceImpl(DataService dataService, GrantedAuthoritiesMapper grantedAuthoritiesMapper) {
        this.dataService = Objects.requireNonNull(dataService);
        this.grantedAuthoritiesMapper = Objects.requireNonNull(grantedAuthoritiesMapper);
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional(readOnly=true)
    public List<User> getUsers() {
        return this.dataService.findAll("sys_sec_User", User.class).collect(Collectors.toList());
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional(readOnly=true)
    public List<Group> getGroups() {
        return this.dataService.findAll("sys_sec_Group", Group.class).collect(Collectors.toList());
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional(readOnly=true)
    public List<Plugin> getPlugins() {
        return this.dataService.findAll("sys_Plugin", Plugin.class).collect(Collectors.toList());
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    public List<Object> getEntityClassIds() {
        return this.dataService.findAll("sys_md_EntityType").map(Entity::getIdValue).collect(Collectors.toList());
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional(readOnly=true)
    public Permissions getGroupPluginPermissions(String groupId) {
        Group group = (Group)this.dataService.findOneById("sys_sec_Group", (Object)groupId, Group.class);
        if (group == null) {
            throw new RuntimeException("unknown group id [" + groupId + "]");
        }
        List<Authority> groupPermissions = this.getGroupPermissions(group);
        Permissions permissions = this.createPermissions(groupPermissions, "ROLE_PLUGIN_");
        permissions.setGroupId(groupId);
        return permissions;
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional(readOnly=true)
    public Permissions getGroupEntityClassPermissions(String groupId) {
        Group group = (Group)this.dataService.findOneById("sys_sec_Group", (Object)groupId, Group.class);
        if (group == null) {
            throw new RuntimeException("unknown group id [" + groupId + "]");
        }
        List<Authority> groupPermissions = this.getGroupPermissions(group);
        Permissions permissions = this.createPermissions(groupPermissions, "ROLE_ENTITY_");
        permissions.setGroupId(groupId);
        return permissions;
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional(readOnly=true)
    public Permissions getUserPluginPermissions(String userId) {
        List<? extends Authority> userPermissions = this.getUserPermissions(userId);
        Permissions permissions = this.createPermissions(userPermissions, "ROLE_PLUGIN_");
        permissions.setUserId(userId);
        return permissions;
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional(readOnly=true)
    public Permissions getUserEntityClassPermissions(String userId) {
        List<? extends Authority> userPermissions = this.getUserPermissions(userId);
        Permissions permissions = this.createPermissions(userPermissions, "ROLE_ENTITY_");
        permissions.setUserId(userId);
        return permissions;
    }

    private List<? extends Authority> getUserPermissions(String userId) {
        return this.getUserPermissions(userId, null);
    }

    private List<? extends Authority> getUserPermissions(String userId, String authorityPrefix) {
        List groups;
        List<Authority> groupAuthorities;
        User user = (User)this.dataService.findOneById("sys_sec_User", (Object)userId, User.class);
        if (user == null) {
            throw new RuntimeException("unknown user id [" + userId + "]");
        }
        List<Authority> userPermissions = this.getUserPermissions(user, authorityPrefix);
        List groupMembers = this.dataService.findAll("sys_sec_GroupMember", new QueryImpl().eq("User", (Object)user), GroupMember.class).collect(Collectors.toList());
        if (!groupMembers.isEmpty() && (groupAuthorities = this.getGroupPermissions(groups = Lists.transform(groupMembers, GroupMember::getGroup), authorityPrefix)) != null && !groupAuthorities.isEmpty()) {
            userPermissions.addAll(groupAuthorities);
        }
        return userPermissions;
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional
    public void replaceGroupPluginPermissions(List<GroupAuthority> pluginAuthorities, String groupId) {
        this.replaceGroupPermissions(pluginAuthorities, groupId, "ROLE_PLUGIN_");
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional
    public void replaceGroupEntityClassPermissions(List<GroupAuthority> entityAuthorities, String groupId) {
        this.replaceGroupPermissions(entityAuthorities, groupId, "ROLE_ENTITY_");
    }

    private void replaceGroupPermissions(List<GroupAuthority> entityAuthorities, String groupId, String authorityPrefix) {
        Group group = (Group)this.dataService.findOneById("sys_sec_Group", (Object)groupId, Group.class);
        if (group == null) {
            throw new RuntimeException("unknown group id [" + groupId + "]");
        }
        for (GroupAuthority entityAuthority : entityAuthorities) {
            entityAuthority.setGroup(group);
        }
        Stream oldEntityAuthorities = this.getGroupPermissions(group, authorityPrefix).stream();
        if (oldEntityAuthorities != null) {
            this.dataService.delete("sys_sec_GroupAuthority", oldEntityAuthorities);
        }
        if (!entityAuthorities.isEmpty()) {
            this.dataService.add("sys_sec_GroupAuthority", entityAuthorities.stream());
        }
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional
    public void replaceUserPluginPermissions(List<UserAuthority> pluginAuthorities, String userId) {
        this.replaceUserPermissions(pluginAuthorities, userId, "ROLE_PLUGIN_");
    }

    @Override
    @PreAuthorize(value="hasAnyRole('ROLE_SU')")
    @Transactional
    public void replaceUserEntityClassPermissions(List<UserAuthority> pluginAuthorities, String userId) {
        this.replaceUserPermissions(pluginAuthorities, userId, "ROLE_ENTITY_");
    }

    private void replaceUserPermissions(List<UserAuthority> entityAuthorities, String userId, String authorityType) {
        User user = (User)this.dataService.findOneById("sys_sec_User", (Object)userId, User.class);
        if (user == null) {
            throw new RuntimeException("unknown user id [" + userId + "]");
        }
        for (UserAuthority entityAuthority : entityAuthorities) {
            entityAuthority.setUser(user);
        }
        List<Authority> oldEntityAuthorities = this.getUserPermissions(user, authorityType);
        if (oldEntityAuthorities != null && !oldEntityAuthorities.isEmpty()) {
            this.dataService.delete("sys_sec_UserAuthority", oldEntityAuthorities.stream());
        }
        if (!entityAuthorities.isEmpty()) {
            this.dataService.add("sys_sec_UserAuthority", entityAuthorities.stream());
        }
    }

    private List<Authority> getUserPermissions(User user, String authorityPrefix) {
        Stream authorities = this.dataService.findAll("sys_sec_UserAuthority", new QueryImpl().eq("User", (Object)user), UserAuthority.class);
        return authorities.filter(authority -> authorityPrefix != null ? authority.getRole().startsWith(authorityPrefix) : true).collect(Collectors.toList());
    }

    private List<Authority> getGroupPermissions(Group group) {
        return this.getGroupPermissions(Arrays.asList(group));
    }

    private List<Authority> getGroupPermissions(Group group, String authorityPrefix) {
        return this.getGroupPermissions(Arrays.asList(group), authorityPrefix);
    }

    private List<Authority> getGroupPermissions(List<Group> groups) {
        return this.getGroupPermissions(groups, null);
    }

    private List<Authority> getGroupPermissions(List<Group> groups, String authorityPrefix) {
        Stream authorities = this.dataService.findAll("sys_sec_GroupAuthority", new QueryImpl().in("Group", groups), GroupAuthority.class);
        return authorities.filter(authority -> authorityPrefix != null ? authority.getRole().startsWith(authorityPrefix) : true).collect(Collectors.toList());
    }

    /*
     * WARNING - void declaration
     */
    private Permissions createPermissions(List<? extends Authority> entityAuthorities, String authorityPrefix) {
        void var5_8;
        Permissions permissions = new Permissions();
        String string = authorityPrefix;
        int n = -1;
        switch (string.hashCode()) {
            case -2135208765: {
                if (!string.equals("ROLE_PLUGIN_")) break;
                boolean bl = false;
                break;
            }
            case 1043557907: {
                if (!string.equals("ROLE_ENTITY_")) break;
                boolean bl = true;
            }
        }
        switch (var5_8) {
            case 0: {
                List<Plugin> plugins = this.getPlugins();
                if (plugins == null) break;
                plugins.sort(Comparator.comparing(Plugin::getId));
                LinkedHashMap<String, String> pluginMap = new LinkedHashMap<String, String>();
                for (Plugin plugin : plugins) {
                    pluginMap.put(plugin.getId(), plugin.getId());
                }
                permissions.setEntityIds(pluginMap);
                break;
            }
            case 1: {
                List<Object> entityClassIds = this.getEntityClassIds();
                List entityTypes = this.dataService.findAll("sys_md_EntityType", entityClassIds.stream(), new Fetch().field("id").field("package"), EntityType.class).collect(Collectors.toList());
                if (entityClassIds == null) break;
                TreeMap<String, String> entityClassMap = new TreeMap<String, String>();
                for (EntityType entityType : entityTypes) {
                    entityClassMap.put(entityType.getId(), entityType.getId());
                }
                permissions.setEntityIds(entityClassMap);
                break;
            }
            default: {
                throw new RuntimeException("Invalid authority prefix [" + authorityPrefix + "]");
            }
        }
        for (Authority authority : entityAuthorities) {
            if (authority.getRole().startsWith(authorityPrefix)) {
                Permission permission = new Permission();
                String authorityType = this.getAuthorityType(authority.getRole(), authorityPrefix);
                String authorityPluginId = this.getAuthorityEntityId(authority.getRole(), authorityPrefix);
                permission.setType(authorityType);
                if (authority instanceof GroupAuthority) {
                    permission.setGroup(((GroupAuthority)authority).getGroup().getName());
                    permissions.addGroupPermission(authorityPluginId, permission);
                } else {
                    permissions.addUserPermission(authorityPluginId, permission);
                }
            }
            SimpleGrantedAuthority grantedAuthority = new SimpleGrantedAuthority(authority.getRole());
            Collection hierarchyAuthorities = this.grantedAuthoritiesMapper.mapAuthorities(Collections.singletonList(grantedAuthority));
            hierarchyAuthorities.remove(grantedAuthority);
            for (GrantedAuthority hierarchyAuthority : hierarchyAuthorities) {
                if (!hierarchyAuthority.getAuthority().startsWith(authorityPrefix)) continue;
                String authorityPluginId = this.getAuthorityEntityId(hierarchyAuthority.getAuthority(), authorityPrefix);
                Permission hierarchyPermission = new Permission();
                hierarchyPermission.setType(this.getAuthorityType(hierarchyAuthority.getAuthority(), authorityPrefix));
                permissions.addHierarchyPermission(authorityPluginId, hierarchyPermission);
            }
        }
        permissions.sort();
        return permissions;
    }

    private String getAuthorityEntityId(String role, String authorityPrefix) {
        role = role.substring(authorityPrefix.length());
        return role.substring(role.indexOf(95) + 1).toLowerCase();
    }

    private String getAuthorityType(String role, String authorityPrefix) {
        role = role.substring(authorityPrefix.length());
        return role.substring(0, role.indexOf(95)).toLowerCase();
    }
}

