/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.twofactor.auth;

import java.util.Objects;
import org.molgenis.security.twofactor.auth.TwoFactorAuthenticationProvider;
import org.molgenis.security.twofactor.auth.TwoFactorAuthenticationToken;
import org.molgenis.security.twofactor.service.OtpService;
import org.molgenis.security.twofactor.service.RecoveryService;
import org.molgenis.security.twofactor.service.TwoFactorAuthenticationService;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class TwoFactorAuthenticationProviderImpl
implements TwoFactorAuthenticationProvider {
    private final TwoFactorAuthenticationService twoFactorAuthenticationService;
    private final OtpService otpService;
    private final RecoveryService recoveryService;

    public TwoFactorAuthenticationProviderImpl(TwoFactorAuthenticationService twoFactorAuthenticationService, OtpService otpService, RecoveryService recoveryService) {
        this.twoFactorAuthenticationService = Objects.requireNonNull(twoFactorAuthenticationService);
        this.otpService = Objects.requireNonNull(otpService);
        this.recoveryService = Objects.requireNonNull(recoveryService);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        if (!this.supports(authentication.getClass())) {
            throw new IllegalArgumentException("Only TwoFactorAuthenticationToken is supported");
        }
        TwoFactorAuthenticationToken authToken = (TwoFactorAuthenticationToken)authentication;
        if (!this.twoFactorAuthenticationService.isConfiguredForUser()) {
            if (authToken.getSecretKey() == null) throw new BadCredentialsException("Invalid secret generated");
            if (!this.otpService.tryVerificationCode(authToken.getVerificationCode(), authToken.getSecretKey())) return authToken;
            this.activateTwoFactorAuthentication(authToken);
            UserDetails userDetails = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
            return new TwoFactorAuthenticationToken(userDetails, userDetails.getPassword(), userDetails.getAuthorities(), authToken.getVerificationCode(), authToken.getSecretKey());
        }
        if (authToken.getVerificationCode() == null) throw new BadCredentialsException("Invalid verification code entered");
        if (!this.twoFactorAuthenticationService.isVerificationCodeValidForUser(authToken.getVerificationCode())) return authToken;
        UserDetails userDetails = (UserDetails)SecurityContextHolder.getContext().getAuthentication().getPrincipal();
        return new TwoFactorAuthenticationToken(userDetails, userDetails.getPassword(), userDetails.getAuthorities(), authToken.getVerificationCode(), null);
    }

    private void activateTwoFactorAuthentication(TwoFactorAuthenticationToken authToken) {
        this.twoFactorAuthenticationService.enableForUser();
        this.twoFactorAuthenticationService.saveSecretForUser(authToken.getSecretKey());
        this.recoveryService.generateRecoveryCodes();
    }

    public boolean supports(Class<?> authentication) {
        return TwoFactorAuthenticationToken.class.isAssignableFrom(authentication);
    }
}

