/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.account;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import javax.naming.NoPermissionException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.molgenis.auth.User;
import org.molgenis.auth.UserFactory;
import org.molgenis.data.MolgenisDataAccessException;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.security.account.AccountService;
import org.molgenis.security.account.ChangePasswordForm;
import org.molgenis.security.account.EmailAlreadyExistsException;
import org.molgenis.security.account.PasswordResetRequest;
import org.molgenis.security.account.RegisterRequest;
import org.molgenis.security.account.UsernameAlreadyExistsException;
import org.molgenis.security.captcha.CaptchaException;
import org.molgenis.security.captcha.CaptchaRequest;
import org.molgenis.security.captcha.CaptchaService;
import org.molgenis.security.settings.AuthenticationSettings;
import org.molgenis.security.user.MolgenisUserException;
import org.molgenis.util.CountryCodes;
import org.molgenis.util.ErrorMessageResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.util.StringUtils;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@Controller
@RequestMapping(value={"/account"})
public class AccountController {
    private static final Logger LOG = LoggerFactory.getLogger(AccountController.class);
    public static final String URI = "/account";
    private static final String CHANGE_PASSWORD_RELATIVE_URI = "/password/change";
    public static final String CHANGE_PASSWORD_URI = "/account/password/change";
    static final String REGISTRATION_SUCCESS_MESSAGE_USER = "You have successfully registered, an activation e-mail has been sent to your email.";
    static final String REGISTRATION_SUCCESS_MESSAGE_ADMIN = "You have successfully registered, your request has been forwarded to the administrator.";
    private final AccountService accountService;
    private final CaptchaService captchaService;
    private final RedirectStrategy redirectStrategy;
    private final AuthenticationSettings authenticationSettings;
    private final UserFactory userFactory;

    public AccountController(AccountService accountService, CaptchaService captchaService, RedirectStrategy redirectStrategy, AuthenticationSettings authenticationSettings, UserFactory userFactory) {
        this.accountService = Objects.requireNonNull(accountService);
        this.captchaService = Objects.requireNonNull(captchaService);
        this.redirectStrategy = Objects.requireNonNull(redirectStrategy);
        this.authenticationSettings = Objects.requireNonNull(authenticationSettings);
        this.userFactory = Objects.requireNonNull(userFactory);
    }

    @GetMapping(value={"/login"})
    public String getLoginForm() {
        return "login-modal";
    }

    @GetMapping(value={"/register"})
    public ModelAndView getRegisterForm() {
        ModelAndView model = new ModelAndView("register-modal");
        model.addObject("countries", (Object)CountryCodes.get());
        model.addObject("min_password_length", (Object)6);
        return model;
    }

    @GetMapping(value={"/password/reset"})
    public String getPasswordResetForm() {
        return "resetpassword-modal";
    }

    @GetMapping(value={"/password/change"})
    public ModelAndView getChangePasswordForm() {
        ModelAndView model = new ModelAndView("view-change-password");
        model.addObject("min_password_length", (Object)6);
        return model;
    }

    @PostMapping(value={"/password/change"})
    public void changePassword(@Valid ChangePasswordForm form, HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null) {
                this.accountService.changePassword(authentication.getName(), form.getPassword1());
            }
            this.redirectStrategy.sendRedirect(request, response, "/");
        }
        catch (Exception e) {
            LOG.error("Error changing password", (Throwable)e);
        }
    }

    @PostMapping(value={"/register"}, headers={"Content-Type=application/x-www-form-urlencoded"})
    @ResponseBody
    public Map<String, String> registerUser(@Valid @ModelAttribute RegisterRequest registerRequest, @Valid @ModelAttribute CaptchaRequest captchaRequest, HttpServletRequest request) throws Exception {
        if (this.authenticationSettings.getSignUp()) {
            if (!registerRequest.getPassword().equals(registerRequest.getConfirmPassword())) {
                throw new BindException(RegisterRequest.class, "password does not match confirm password");
            }
            if (!this.captchaService.validateCaptcha(captchaRequest.getCaptcha())) {
                throw new CaptchaException("invalid captcha answer");
            }
            User user = this.toUser(registerRequest);
            String activationUri = null;
            if (StringUtils.isEmpty((Object)request.getHeader("X-Forwarded-Host"))) {
                activationUri = ServletUriComponentsBuilder.fromCurrentRequest().replacePath("/account/activate").build().toUriString();
            } else {
                String scheme = request.getHeader("X-Forwarded-Proto");
                if (scheme == null) {
                    scheme = request.getScheme();
                }
                activationUri = scheme + "://" + request.getHeader("X-Forwarded-Host") + URI + "/activate";
            }
            this.accountService.createUser(user, activationUri);
            String successMessage = this.authenticationSettings.getSignUpModeration() ? REGISTRATION_SUCCESS_MESSAGE_ADMIN : REGISTRATION_SUCCESS_MESSAGE_USER;
            this.captchaService.removeCaptcha();
            return Collections.singletonMap("message", successMessage);
        }
        throw new NoPermissionException("Self registration is disabled");
    }

    @GetMapping(value={"/activate/{activationCode}"})
    public String activateUser(@Valid @NotNull @PathVariable String activationCode, Model model) {
        try {
            this.accountService.activateUser(activationCode);
            model.addAttribute("successMessage", (Object)"Your account has been activated, you can now sign in.");
        }
        catch (MolgenisUserException e) {
            model.addAttribute("warningMessage", (Object)e.getMessage());
        }
        catch (RuntimeException e) {
            model.addAttribute("errorMessage", (Object)e.getMessage());
        }
        return "forward:/";
    }

    @PostMapping(value={"/password/reset"}, headers={"Content-Type=application/x-www-form-urlencoded"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void resetPassword(@Valid @ModelAttribute PasswordResetRequest passwordResetRequest) {
        this.accountService.resetPassword(passwordResetRequest.getEmail());
    }

    @ExceptionHandler(value={MolgenisDataAccessException.class})
    @ResponseStatus(value=HttpStatus.UNAUTHORIZED)
    private void handleMolgenisDataAccessException(MolgenisDataAccessException e) {
    }

    @ExceptionHandler(value={CaptchaException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    private void handleCaptchaException(CaptchaException e) {
    }

    @ExceptionHandler(value={MolgenisUserException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorMessageResponse handleMolgenisUserException(MolgenisUserException e) {
        LOG.debug("", (Throwable)e);
        return new ErrorMessageResponse(Collections.singletonList(new ErrorMessageResponse.ErrorMessage(e.getMessage())));
    }

    @ExceptionHandler(value={UsernameAlreadyExistsException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorMessageResponse handleUsernameAlreadyExistsException(UsernameAlreadyExistsException e) {
        LOG.debug("", (Throwable)e);
        return new ErrorMessageResponse(Collections.singletonList(new ErrorMessageResponse.ErrorMessage(e.getMessage())));
    }

    @ExceptionHandler(value={EmailAlreadyExistsException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ErrorMessageResponse handleEmailAlreadyExistsException(EmailAlreadyExistsException e) {
        LOG.debug("", (Throwable)e);
        return new ErrorMessageResponse(Collections.singletonList(new ErrorMessageResponse.ErrorMessage(e.getMessage())));
    }

    @ExceptionHandler(value={MolgenisDataException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessageResponse handleMolgenisDataException(MolgenisDataException e) {
        LOG.error("", (Throwable)e);
        return new ErrorMessageResponse(Collections.singletonList(new ErrorMessageResponse.ErrorMessage(e.getMessage())));
    }

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    @ResponseBody
    public ErrorMessageResponse handleRuntimeException(RuntimeException e) {
        LOG.error("", (Throwable)e);
        return new ErrorMessageResponse(Collections.singletonList(new ErrorMessageResponse.ErrorMessage(e.getMessage())));
    }

    private User toUser(RegisterRequest request) {
        User user = (User)this.userFactory.create();
        user.setUsername(request.getUsername());
        user.setPassword(request.getPassword());
        user.setEmail(request.getEmail());
        user.setPhone(request.getPhone());
        user.setFax(request.getFax());
        user.setTollFreePhone(request.getTollFreePhone());
        user.setAddress(request.getAddress());
        user.setTitle(request.getTitle());
        user.setLastName(request.getLastname());
        user.setFirstName(request.getFirstname());
        user.setDepartment(request.getDepartment());
        user.setCity(request.getCity());
        user.setCountry(CountryCodes.get((String)request.getCountry()));
        user.setChangePassword(Boolean.valueOf(false));
        user.setSuperuser(Boolean.valueOf(false));
        return user;
    }
}

