/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.login;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.security.web.authentication.session.SessionAuthenticationException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/login"})
public class MolgenisLoginController {
    public static final String URI = "/login";
    public static final String SESSION_EXPIRED_SESSION_ATTRIBUTE = "sessionExpired";
    public static final String ERROR_MESSAGE_ATTRIBUTE = "errorMessage";
    private static final String ERROR_MESSAGE_BAD_CREDENTIALS = "The username or password you entered is incorrect.";
    public static final String ERROR_MESSAGE_DISABLED = "Your account is not yet activated.";
    private static final String ERROR_MESSAGE_SESSION_AUTHENTICATION = "Your login session has expired.";
    private static final String ERROR_MESSAGE_UNKNOWN = "Sign in failed.";
    public static final String VIEW_LOGIN = "view-login";

    @GetMapping
    public String getLoginPage(Model model, HttpSession session) {
        if (session.getAttribute(SESSION_EXPIRED_SESSION_ATTRIBUTE) != null) {
            model.addAttribute(ERROR_MESSAGE_ATTRIBUTE, (Object)ERROR_MESSAGE_SESSION_AUTHENTICATION);
            session.removeAttribute(SESSION_EXPIRED_SESSION_ATTRIBUTE);
        }
        return VIEW_LOGIN;
    }

    @GetMapping(params={"error"})
    public String getLoginErrorPage(Model model, HttpServletRequest request, HttpServletResponse response) {
        Object attribute = request.getSession().getAttribute("SPRING_SECURITY_LAST_EXCEPTION");
        String errorMessage = attribute != null ? (attribute instanceof BadCredentialsException ? ERROR_MESSAGE_BAD_CREDENTIALS : (attribute instanceof SessionAuthenticationException ? ERROR_MESSAGE_SESSION_AUTHENTICATION : (!this.determineErrorMessagesFromInternalAuthenticationExceptions(attribute).isEmpty() ? this.determineErrorMessagesFromInternalAuthenticationExceptions(attribute) : ERROR_MESSAGE_UNKNOWN))) : ERROR_MESSAGE_UNKNOWN;
        model.addAttribute(ERROR_MESSAGE_ATTRIBUTE, (Object)errorMessage);
        return VIEW_LOGIN;
    }

    private String determineErrorMessagesFromInternalAuthenticationExceptions(Object attribute) {
        Throwable throwable;
        String errorMessage = "";
        if (attribute instanceof InternalAuthenticationServiceException && (throwable = ((InternalAuthenticationServiceException)((Object)attribute)).getCause()).getCause() instanceof UsernameNotFoundException) {
            errorMessage = ERROR_MESSAGE_BAD_CREDENTIALS;
        }
        return errorMessage;
    }
}

