/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.permission;

import java.util.Collection;
import org.molgenis.security.core.Permission;
import org.molgenis.security.core.PermissionService;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;

@Component
public class PermissionServiceImpl
implements PermissionService {
    public boolean hasPermissionOnPlugin(String pluginId, Permission permission) {
        return this.hasPermission(pluginId, permission, "ROLE_PLUGIN_");
    }

    public boolean hasPermissionOnEntityType(String entityTypeId, Permission permission) {
        return this.hasPermission(entityTypeId, permission, "ROLE_ENTITY_");
    }

    private boolean hasPermission(String authorityId, Permission permission, String authorityPrefix) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            return false;
        }
        String pluginAuthority = authorityPrefix + permission.toString() + '_' + authorityId;
        Collection grantedAuthorities = authentication.getAuthorities();
        if (grantedAuthorities != null) {
            for (GrantedAuthority grantedAuthority : grantedAuthorities) {
                String authority = grantedAuthority.getAuthority();
                if (!authority.equals("ROLE_SU") && !authority.equals("ROLE_SYSTEM") && !authority.equals(pluginAuthority)) continue;
                return true;
            }
        }
        return false;
    }
}

