/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.token;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Objects;
import org.molgenis.auth.Token;
import org.molgenis.auth.TokenFactory;
import org.molgenis.auth.User;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.security.core.runas.RunAsSystem;
import org.molgenis.security.core.token.TokenService;
import org.molgenis.security.core.token.UnknownTokenException;
import org.molgenis.security.token.TokenGenerator;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.transaction.annotation.Transactional;

public class DataServiceTokenService
implements TokenService {
    private final TokenGenerator tokenGenerator;
    private final DataService dataService;
    private final UserDetailsService userDetailsService;
    private final TokenFactory tokenFactory;

    public DataServiceTokenService(TokenGenerator tokenGenerator, DataService dataService, UserDetailsService userDetailsService, TokenFactory tokenFactory) {
        this.tokenGenerator = Objects.requireNonNull(tokenGenerator);
        this.dataService = Objects.requireNonNull(dataService);
        this.userDetailsService = Objects.requireNonNull(userDetailsService);
        this.tokenFactory = Objects.requireNonNull(tokenFactory);
    }

    @Transactional(readOnly=true)
    @RunAsSystem
    public UserDetails findUserByToken(String token) {
        Token molgenisToken = this.getMolgenisToken(token);
        return this.userDetailsService.loadUserByUsername(molgenisToken.getUser().getUsername());
    }

    @Transactional
    @RunAsSystem
    public String generateAndStoreToken(String username, String description) {
        User user = (User)this.dataService.query("sys_sec_User", User.class).eq("username", (Object)username).findOne();
        if (user == null) {
            throw new IllegalArgumentException(String.format("Unknown username [%s]", username));
        }
        String token = this.tokenGenerator.generateToken();
        Token molgenisToken = (Token)this.tokenFactory.create();
        molgenisToken.setUser(user);
        molgenisToken.setToken(token);
        molgenisToken.setDescription(description);
        molgenisToken.setExpirationDate(Instant.now().plus(2L, ChronoUnit.HOURS));
        this.dataService.add("sys_sec_Token", (Entity)molgenisToken);
        return token;
    }

    @Transactional
    @RunAsSystem
    public void removeToken(String token) {
        Token molgenisToken = this.getMolgenisToken(token);
        this.dataService.delete("sys_sec_Token", (Entity)molgenisToken);
    }

    private Token getMolgenisToken(String token) {
        Token molgenisToken = (Token)this.dataService.query("sys_sec_Token", Token.class).eq("token", (Object)token).findOne();
        if (molgenisToken == null || molgenisToken.isExpired()) {
            throw new UnknownTokenException("Invalid token");
        }
        return molgenisToken;
    }
}

