/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.settings;

import java.util.Arrays;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.settings.DefaultSettingsEntity;
import org.molgenis.data.settings.DefaultSettingsEntityType;
import org.molgenis.security.settings.AuthenticationSettings;
import org.molgenis.security.twofactor.auth.TwoFactorAuthenticationSetting;
import org.springframework.stereotype.Component;

@Component
public class AuthenticationSettingsImpl
extends DefaultSettingsEntity
implements AuthenticationSettings {
    private static final long serialVersionUID = 1L;
    private static final String ID = "auth";

    public AuthenticationSettingsImpl() {
        super(ID);
    }

    @Override
    public boolean getSignUp() {
        Boolean value = this.getBoolean("signup");
        return value != null ? value : false;
    }

    @Override
    public void setSignUp(boolean signUp) {
        this.set("signup", signUp);
    }

    @Override
    public boolean getSignUpModeration() {
        Boolean value = this.getBoolean("signup_moderation");
        return value != null ? value : false;
    }

    @Override
    public void setSignUpModeration(boolean signUpModeration) {
        this.set("signup_moderation", signUpModeration);
    }

    @Override
    public void setGoogleSignIn(boolean googleSignIn) {
        this.set("google_sign_in", googleSignIn);
    }

    @Override
    public boolean getGoogleSignIn() {
        Boolean value = this.getBoolean("google_sign_in");
        return value != null ? value : false;
    }

    @Override
    public void setGoogleAppClientId(String googleAppClientId) {
        this.set("google_app_client_id", googleAppClientId);
    }

    @Override
    public String getGoogleAppClientId() {
        return this.getString("google_app_client_id");
    }

    @Override
    public void setTwoFactorAuthentication(TwoFactorAuthenticationSetting twoFactorAuthentication) {
        this.set("sign_in_2fa", twoFactorAuthentication.getLabel());
    }

    @Override
    public TwoFactorAuthenticationSetting getTwoFactorAuthentication() {
        return TwoFactorAuthenticationSetting.fromLabel(this.getString("sign_in_2fa"));
    }

    @Component
    public static class Meta
    extends DefaultSettingsEntityType {
        private static final String SIGNUP = "signup";
        private static final String SIGNUP_MODERATION = "signup_moderation";
        private static final String GOOGLE_SIGN_IN = "google_sign_in";
        private static final String GOOGLE_APP_CLIENT_ID = "google_app_client_id";
        private static final String SIGN_IN_2FA = "sign_in_2fa";
        private static final boolean DEFAULT_SIGNUP = false;
        private static final boolean DEFAULT_SIGNUP_MODERATION = true;
        private static final boolean DEFAULT_GOOGLE_SIGN_IN = true;
        private static final String DEFAULT_GOOGLE_APP_CLIENT_ID = "130634143611-e2518d1uqu0qtec89pjgn50gbg95jin4.apps.googleusercontent.com";

        public Meta() {
            super(AuthenticationSettingsImpl.ID);
        }

        public void init() {
            super.init();
            this.setLabel("Authentication settings");
            this.setDescription("Settings for authentication methods and user sign-up.");
            this.addAttribute(SIGNUP, new EntityType.AttributeRole[0]).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(false)).setLabel("Allow users to sign up");
            this.addAttribute(SIGNUP_MODERATION, new EntityType.AttributeRole[0]).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Sign up moderation").setDescription("Admins must accept sign up requests before account activation").setVisibleExpression("$('signup').eq(true).value()");
            this.addAttribute(GOOGLE_SIGN_IN, new EntityType.AttributeRole[0]).setDataType(AttributeType.BOOL).setNillable(false).setDefaultValue(String.valueOf(true)).setLabel("Enable Google Sign-In").setDescription("Enable users to sign in with their existing Google account").setVisibleExpression("$('signup').eq(true).value() && $('signup_moderation').eq(false).value()");
            this.addAttribute(GOOGLE_APP_CLIENT_ID, new EntityType.AttributeRole[0]).setDataType(AttributeType.STRING).setNillable(false).setDefaultValue(DEFAULT_GOOGLE_APP_CLIENT_ID).setLabel("Google app client ID").setDescription("Google app client ID used during Google Sign-In").setVisibleExpression("$('google_sign_in').eq(true).value()");
            this.addAttribute(SIGN_IN_2FA, new EntityType.AttributeRole[0]).setDataType(AttributeType.ENUM).setNillable(false).setDefaultValue(TwoFactorAuthenticationSetting.DISABLED.getLabel()).setEnumOptions(Arrays.asList(TwoFactorAuthenticationSetting.DISABLED.getLabel(), TwoFactorAuthenticationSetting.ENABLED.getLabel(), TwoFactorAuthenticationSetting.ENFORCED.getLabel())).setLabel("Two Factor Authentication").setDescription("Enable or enforce users to sign in with Google Authenticator. Can not be used when Google Sign-In is enabled.").setValidationExpression(Meta.getSignIn2FAValidationExpression());
        }

        private static String getSignIn2FAValidationExpression() {
            return String.format("$('%s').eq('%s').or($('%s').not()).or($('%s')).or($('%s').not()).value()", SIGN_IN_2FA, TwoFactorAuthenticationSetting.DISABLED.getLabel(), SIGNUP, SIGNUP_MODERATION, GOOGLE_SIGN_IN);
        }
    }
}

