/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.google;

import com.google.api.client.googleapis.auth.oauth2.GoogleIdToken;
import com.google.api.client.googleapis.auth.oauth2.GoogleIdTokenVerifier;
import com.google.api.client.googleapis.auth.oauth2.GooglePublicKeysManager;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.molgenis.auth.Group;
import org.molgenis.auth.GroupMember;
import org.molgenis.auth.GroupMemberFactory;
import org.molgenis.auth.User;
import org.molgenis.auth.UserFactory;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.security.core.runas.RunAsSystemAspect;
import org.molgenis.security.core.token.UnknownTokenException;
import org.molgenis.security.settings.AuthenticationSettings;
import org.molgenis.security.user.UserDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;
import org.springframework.security.authentication.AuthenticationServiceException;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.DisabledException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.web.authentication.AbstractAuthenticationProcessingFilter;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;

public class GoogleAuthenticationProcessingFilter
extends AbstractAuthenticationProcessingFilter {
    private static final Logger LOG = LoggerFactory.getLogger(GoogleAuthenticationProcessingFilter.class);
    public static final String GOOGLE_AUTHENTICATION_URL = "/login/google";
    static final String PARAM_ID_TOKEN = "id_token";
    private static final String PROFILE_KEY_GIVEN_NAME = "given_name";
    private static final String PROFILE_KEY_FAMILY_NAME = "family_name";
    private final GooglePublicKeysManager googlePublicKeysManager;
    private final DataService dataService;
    private final UserDetailsService userDetailsService;
    private final AuthenticationSettings authenticationSettings;
    private final UserFactory userFactory;
    private final GroupMemberFactory groupMemberFactory;

    public GoogleAuthenticationProcessingFilter(GooglePublicKeysManager googlePublicKeysManager, DataService dataService, UserDetailsService userDetailsService, AuthenticationSettings authenticationSettings, UserFactory userFactory, GroupMemberFactory groupMemberFactory) {
        super((RequestMatcher)new AntPathRequestMatcher(GOOGLE_AUTHENTICATION_URL, HttpMethod.POST.toString()));
        this.userFactory = Objects.requireNonNull(userFactory);
        this.groupMemberFactory = Objects.requireNonNull(groupMemberFactory);
        this.setAuthenticationFailureHandler((AuthenticationFailureHandler)new SimpleUrlAuthenticationFailureHandler("/login?error"));
        this.googlePublicKeysManager = Objects.requireNonNull(googlePublicKeysManager);
        this.dataService = Objects.requireNonNull(dataService);
        this.userDetailsService = Objects.requireNonNull(userDetailsService);
        this.authenticationSettings = Objects.requireNonNull(authenticationSettings);
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (!this.authenticationSettings.getGoogleSignIn()) {
            throw new AuthenticationServiceException("Google authentication not available");
        }
        String idTokenString = request.getParameter(PARAM_ID_TOKEN);
        if (idTokenString != null) {
            GoogleIdToken idToken;
            try {
                idToken = this.verify(idTokenString);
            }
            catch (GeneralSecurityException e) {
                throw new UnknownTokenException(e.getMessage(), (Throwable)e);
            }
            if (idToken != null) {
                return this.createAuthentication(idToken.getPayload());
            }
            throw new BadCredentialsException(String.format("Token [%s] verification failed", idTokenString));
        }
        throw new UnknownTokenException(idTokenString);
    }

    private GoogleIdToken verify(String idTokenString) throws GeneralSecurityException, IOException {
        List<String> audience = Collections.singletonList(this.authenticationSettings.getGoogleAppClientId());
        GoogleIdTokenVerifier googleIdTokenVerifier = new GoogleIdTokenVerifier.Builder(this.googlePublicKeysManager).setAudience(audience).build();
        return googleIdTokenVerifier.verify(idTokenString);
    }

    private Authentication createAuthentication(GoogleIdToken.Payload payload) {
        String email = payload.getEmail();
        if (email == null) {
            throw new AuthenticationServiceException("Google URI token is missing required [email] claim, did you forget to specify scope [email]?");
        }
        Boolean emailVerified = payload.getEmailVerified();
        if (emailVerified != null && !emailVerified.booleanValue()) {
            throw new AuthenticationServiceException("Google account email is not verified");
        }
        String principal = payload.getSubject();
        String credentials = payload.getAccessTokenHash();
        return (Authentication)RunAsSystemAspect.runAsSystem(() -> {
            User user = (User)this.dataService.query("sys_sec_User", User.class).eq("googleAccountId", (Object)principal).findOne();
            if (user == null) {
                user = (User)this.dataService.query("sys_sec_User", User.class).eq("Email", (Object)email).findOne();
                if (user != null) {
                    user.setGoogleAccountId(principal);
                    this.dataService.update("sys_sec_User", (Entity)user);
                } else {
                    String username = email;
                    String givenName = payload.containsKey((Object)PROFILE_KEY_GIVEN_NAME) ? payload.get((Object)PROFILE_KEY_GIVEN_NAME).toString() : null;
                    String familyName = payload.containsKey((Object)PROFILE_KEY_FAMILY_NAME) ? payload.get((Object)PROFILE_KEY_FAMILY_NAME).toString() : null;
                    user = this.createMolgenisUser(username, email, givenName, familyName, principal);
                }
            }
            if (!user.isActive().booleanValue()) {
                throw new DisabledException("Your account is not yet activated.");
            }
            Collection<? extends GrantedAuthority> authorities = this.userDetailsService.getAuthorities(user);
            return new UsernamePasswordAuthenticationToken((Object)user.getUsername(), (Object)credentials, authorities);
        });
    }

    private User createMolgenisUser(String username, String email, String givenName, String familyName, String googleAccountId) {
        if (!this.authenticationSettings.getSignUp()) {
            throw new AuthenticationServiceException("Google authentication not possible: sign up disabled");
        }
        if (this.authenticationSettings.getSignUpModeration()) {
            throw new AuthenticationServiceException("Google authentication not possible: sign up moderation enabled");
        }
        LOG.info("first login for [{}], creating MOLGENIS user", (Object)username);
        User user = (User)this.userFactory.create();
        user.setUsername(username);
        user.setPassword(UUID.randomUUID().toString());
        user.setEmail(email);
        user.setActive(Boolean.valueOf(true));
        user.setSuperuser(Boolean.valueOf(false));
        user.setChangePassword(Boolean.valueOf(false));
        if (givenName != null) {
            user.setFirstName(givenName);
        }
        if (familyName != null) {
            user.setLastName(familyName);
        }
        user.setGoogleAccountId(googleAccountId);
        this.dataService.add("sys_sec_User", (Entity)user);
        GroupMember groupMember = (GroupMember)this.groupMemberFactory.create();
        Group group = (Group)this.dataService.query("sys_sec_Group", Group.class).eq("name", (Object)"All Users").findOne();
        groupMember.setGroup(group);
        groupMember.setUser(user);
        this.dataService.add("sys_sec_GroupMember", (Entity)groupMember);
        return user;
    }
}

