/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.security.twofactor.service;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.jboss.aerogear.security.otp.Totp;
import org.molgenis.data.settings.AppSettings;
import org.molgenis.security.core.utils.SecurityUtils;
import org.molgenis.security.twofactor.exceptions.InvalidVerificationCodeException;
import org.molgenis.security.twofactor.service.OtpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class OtpServiceImpl
implements OtpService {
    private static final Logger LOG = LoggerFactory.getLogger(OtpServiceImpl.class);
    private final AppSettings appSettings;

    public OtpServiceImpl(AppSettings appSettings) {
        this.appSettings = appSettings;
    }

    @Override
    public boolean tryVerificationCode(String verificationCode, String secretKey) {
        if (StringUtils.hasText((String)secretKey)) {
            if (verificationCode == null) {
                throw new InvalidVerificationCodeException("Verificationcode is mandatory");
            }
            Totp totp = new Totp(secretKey);
            if (!this.isValidLong(verificationCode) || !totp.verify(verificationCode)) {
                throw new InvalidVerificationCodeException("Invalid verification code entered");
            }
        } else {
            throw new InvalidVerificationCodeException("Two factor authentication secret key is not available");
        }
        boolean isValid = true;
        return isValid;
    }

    @Override
    public String getAuthenticatorURI(String secretKey) {
        String userName = SecurityUtils.getCurrentUsername();
        String appName = this.appSettings.getTitle();
        if (userName == null) {
            String errorMessage = "User is not available";
            LOG.error(errorMessage);
            throw new IllegalStateException(errorMessage);
        }
        String normalizedBase32Key = secretKey.replace(" ", "").toUpperCase();
        try {
            return String.format("otpauth://totp/%s?secret=%s&issuer=%s", URLEncoder.encode(appName + ":" + userName, "UTF-8").replace("+", "%20"), URLEncoder.encode(normalizedBase32Key, "UTF-8").replace("+", "%20"), URLEncoder.encode(appName, "UTF-8").replace("+", "%20"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private boolean isValidLong(String code) {
        try {
            Long.parseLong(code);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }
}

